const config = require('yandex-cfg');
const path = require('path');

/**
 * Возвращает массив с префиксом пути
 * @param {String} host
 * @param {String} router
 * @returns {String []}
 */
function getPathPrefix(host, router) {
    if (!host || host.startsWith(config.host) ||
        host.startsWith(config.alternativeHost)) {
        return [config.router[router]];
    }

    return ['/'];
}

module.exports.buildPath = function (host, ...args) {
    return path.join(...getPathPrefix(host, 'adv').concat(args));
};

module.exports.buildAjaxPath = function (host, ...args) {
    return path.join(...getPathPrefix(host, 'vda').concat(args));
};
