const redirect = require('express-redirect');

module.exports = function (app) {
    /* eslint-disable max-len */
    redirect(app);

    const redirects = {
        // Продукты
        '/adv/products/:section(actions|materials|solutions)(/:page)?': '/adv/:section/:page?'
    };

    const eduRedirects = {
        '/adv/edu/market-basis/dostavka-marketa-podklyuchit': '/adv/edu/market/market-special/dostavka-marketa-podklyuchit',
        '/adv/edu/market-basis/dostavka-marketa-zakazi': '/adv/edu/market/market-special/dostavka-marketa-zakazi',
        '/adv/edu/market-start/kak-zaregistrirovat-magazin-market': '/adv/edu/market/market-start/registratsiya-magazina-i-startovye-nastroyki',
        '/adv/edu/market-start/kak-oplatit-razmeschenie': '/adv/edu/market/market-start/za-chto-platit-magazin-i-kak-popolnit-schet',
        '/adv/edu/market-exp/vvedenie-3': '/adv/edu/market/market-basis/vvedenie-ot-chego-zavisit-uspekh-magazina-na-markete',
        '/adv/edu/market-exp/upravlenie-stavkami': '/adv/edu/market/market-basis/kak-upravlyat-stavkami',
        '/adv/edu/market-exp/pricelabs': '/adv/edu/market/market-basis/pricelabs',
        '/adv/edu/market-exp/otchety-na-markete': '/adv/edu/market/market-basis/otchety-na-markete',
        '/adv/edu/delivery-start/nachalo-raboty-v-dostavke-konspekt': '/adv/edu/market/delivery-start/kak-nachat-rabotu-s-yandeks-dostavkoy',
        '/adv/edu/delivery-start/nastroyka-dostavki-konspekt': '/adv/edu/market/delivery-start/kak-nastroit-usloviya-dostavki-i-dostupy',
        '/adv/edu/delivery-start/nastroyka-tovarov-i-dostupov-konspekt': '/adv/edu/market/delivery-start/kak-nastroit-usloviya-dostavki-i-dostupy',
        '/adv/edu/delivery-start/oformlenie-zakaza-konspekt': '/adv/edu/market/delivery-start/kak-oformit-zakaz-na-dostavku',
        '/adv/edu/delivery-start/razdel-zakazy-konspekt': '/adv/edu/market/delivery-start/gde-i-kak-upravlyat-zakazom-posle-ego-oformleniya',
        '/adv/edu/delivery-start/kak-peredat-zakaz-v-dostavku-konspekt': '/adv/edu/market/delivery-start/gde-i-kak-upravlyat-zakazom-posle-ego-oformleniya',
        '/adv/edu/delivery-start/zayavka-na-zabor-konspekt': '/adv/edu/market/delivery-start/kak-otgruzit-zakaz-sluzhbe-dostavki',
        '/adv/edu/delivery-start/zayavka-na-samoprivoz-konspekt': '/adv/edu/market/delivery-start/kak-otgruzit-zakaz-sluzhbe-dostavki',
        '/adv/edu/delivery-start/zayavki-konspekt': '/adv/edu/market/delivery-start/kak-otgruzit-zakaz-sluzhbe-dostavki',
        '/adv/edu/delivery-start/otchety-po-dostvke-konspekt': '/adv/edu/market/delivery-start/gde-i-kak-rabotat-s-otchetami-po-okazannym-uslugam',
        '/adv/edu/exam-direct': '/adv/edu/direct/direct-start/sozdaem-kampaniyu-dlya-pokaza-v-setyakh',

        '/adv/edu/market-start/kak-ukazat-bazovye-nastroyki-magazina': '/adv/edu/market/market-start',
        '/adv/edu/market-start/otvety-na-kurs-kak-podklyuchitsya-k-servisu-yandeks-market': '/adv/edu/market/market-start',
        '/adv/edu/market-basis/vvedenie': '/adv/edu/market/market-basis',
        '/adv/edu/market-basis/dostavka': '/adv/edu/market/market-basis',
        '/adv/edu/market-basis/tochki-prodazh': '/adv/edu/market/market-basis',
        '/adv/edu/market-basis/predoplata': '/adv/edu/market/market-basis',
        '/adv/edu/market-basis/regulyarnye-proverki': '/adv/edu/market/market-basis',
        '/adv/edu/market-basis/dostup-k-marketu': '/adv/edu/market/market-basis',
        '/adv/edu/market-basis/otvety-na-kurs-osnovy-raboty-na-servise-yandeks-market': '/adv/edu/market/market-basis',
        '/adv/edu/market-exp/ranzhirovanie-na-markete': '/adv/edu/market/market-basis',
        '/adv/edu/market-exp/reyting': '/adv/edu/market/market-basis',
        '/adv/edu/market-exp/vtoroy-magazin': '/adv/edu/market/market-basis',
        '/adv/edu/market-exp/otvety-na-kurs-kak-povysit-effektivnost-razmescheniya-na-yandeks-markete': '/adv/edu/market/market-basis',

        '/adv/edu/delivery-start/kak-nachat-rabotu-s-yandeks-dostavkoy': '/adv/edu/market/delivery-start/kak-nachat-rabotu-s-yandeks-dostavkoy',
        '/adv/edu/delivery-start/kak-nastroit-usloviya-dostavki-i-dostupy': '/adv/edu/market/delivery-start/kak-nastroit-usloviya-dostavki-i-dostupy',
        '/adv/edu/delivery-start/kak-oformit-zakaz-na-dostavku': '/adv/edu/market/delivery-start/kak-oformit-zakaz-na-dostavku',
        '/adv/edu/delivery-start/gde-i-kak-upravlyat-zakazom-posle-ego-oformleniya': '/adv/edu/market/delivery-start/gde-i-kak-upravlyat-zakazom-posle-ego-oformleniya',
        '/adv/edu/delivery-start/kak-otgruzit-zakaz-sluzhbe-dostavki': '/adv/edu/market/delivery-start/kak-otgruzit-zakaz-sluzhbe-dostavki',
        '/adv/edu/delivery-start/gde-i-kak-rabotat-s-otchetami-po-okazannym-uslugam': '/adv/edu/market/delivery-start/gde-i-kak-rabotat-s-otchetami-po-okazannym-uslugam',
        '/adv/edu/delivery-start/otvety-na-kurs-osnovy-raboty-s-yandeks-dostavkoy': '/adv/edu/market/delivery-start',

        '/adv/edu/direct-api/otvety-na-voprosy-k-kursu-chto-takoe-api-direkta-i-kak-nachat-s-nim-rabotat': '/adv/edu/direct/direct-api',
        '/adv/edu/metrika-start/otvety-na-kurs-osnovy-raboty-s-yandeks-metrikoy': '/adv/edu/online/metrika',
        '/adv/edu/webmaster-start/otvety-na-kurs-osnovnye-printsipy-indeksirovaniya': '/adv/edu/webmaster/webmaster-start',
        '/adv/edu/webmaster-optimization/otvety-na-kurs-osnovnye-printsipy-optimizatsii-sayta': '/adv/edu/webmaster/webmaster-optimization',

        '/adv/edu/archive': '/adv/edu/online',
        '/adv/edu/archive_direct': '/adv/edu/online/direct',
        '/adv/edu/archive_metrika': '/adv/edu/online/metrika',

        '/adv/edu/adfox': '/adv/edu/online/adfox',
        '/adv/edu/adfox-start': '/adv/edu/adfox/adfox-start',
        '/adv/edu/adfox-start/:lesson': '/adv/edu/adfox/adfox-start/:lesson',

        '/adv/edu/delivery': '/adv/edu/market/delivery-start',
        '/adv/edu/delivery-start': '/adv/edu/market/delivery-start',
        '/adv/edu/delivery-start/:lesson': '/adv/edu/market/delivery-start/:lesson',

        '/adv/edu/direct': '/adv/edu/online/direct',
        '/adv/edu/direct-api': '/adv/edu/direct/direct-api',
        '/adv/edu/direct-api/:lesson': '/adv/edu/direct/direct-api/:lesson',
        '/adv/edu/direct-budget': '/adv/edu/direct/direct-budget',
        '/adv/edu/direct-budget/:lesson': '/adv/edu/direct/direct-budget/:lesson',
        '/adv/edu/direct-start': '/adv/edu/direct/direct-start',
        '/adv/edu/direct-start/:lesson': '/adv/edu/direct/direct-start/:lesson',

        '/adv/edu/market': '/adv/edu/online/market',
        '/adv/edu/market-basis': '/adv/edu/market/market-basis',
        '/adv/edu/market-basis/:lesson': '/adv/edu/market/market-basis/:lesson',
        '/adv/edu/market-exp': '/adv/edu/market/market-exp',
        '/adv/edu/market-exp/:lesson': '/adv/edu/market/market-exp/:lesson',
        '/adv/edu/market-start': '/adv/edu/market/market-start',
        '/adv/edu/market-start/:lesson': '/adv/edu/market/market-start/:lesson',

        '/adv/edu/metrika': '/adv/edu/online/metrika',
        '/adv/edu/metrika-start': '/adv/edu/metrika/metrika-start',
        '/adv/edu/metrika-start/:lesson': '/adv/edu/metrika/metrika-start/:lesson',

        '/adv/edu/webmaster': '/adv/edu/online/webmaster',
        '/adv/edu/webmaster-optimization': '/adv/edu/webmaster/webmaster-optimization',
        '/adv/edu/webmaster-optimization/:lesson': '/adv/edu/webmaster/webmaster-optimization/:lesson',
        '/adv/edu/webmaster-start': '/adv/edu/webmaster/webmaster-start',
        '/adv/edu/webmaster-start/:lesson': '/adv/edu/webmaster/webmaster-start/:lesson',

        '/adv/edu/outer': '/adv/edu/events',
        '/adv/edu/webinars': '/adv/edu/events',
        '/adv/edu/partners': '/adv/edu/experts'
    };

    // FIXME
    app.use(/\/adv\/edu\/.+/, (req, res, next) => {
        if (['ru', 'com'].indexOf(req.tld) > -1 && Object.prototype.hasOwnProperty.call(eduRedirects, req.baseUrl)) {
            return res.redirect(301, eduRedirects[req.baseUrl]);
        }

        next();
    });

    Object
        .keys(redirects)
        .forEach(from => {
            app.redirect(from, redirects[from], 301);
        });
};
