'use strict';

const path = require('path');
const { router } = require('yandex-cfg');
const fs = require('fs');

module.exports = app => {
    const wwwDir = path.join(__dirname, '..', '..', 'www');
    const files = fs.readdirSync(wwwDir);

    files.forEach(filename => {
        [router.adv, router.vda].forEach(route => {
            app.get(`${route}/${filename}`,
                (req, res) => res.sendFile(path.join(wwwDir, filename)));
        });
    });
};
