'use strict';

const islandsTools = require('../node_modules/islands');

const PLATFORMS = {
    desktop: ['meta', 'common', 'desktop'],
    'touch-phone': ['meta', 'common', 'touch-phone']
};

module.exports = {
    LANGUAGES: ['ru', 'en', 'tr', 'zh-Hans'],
    PLATFORMS,
    BUNDLES_PLATFORMS: ['desktop', 'touch-phone'],
    LIBRARIES: [
        {
            platform: 'desktop',
            levels: islandsTools.getPlatformLevels('desktop')
        },
        {
            platform: 'touch-phone',
            levels: islandsTools.getPlatformLevels('desktop')
        },

        { source: true },

        {
            tech: 'gemini',
            source: false,
            platforms: {
                desktop: ['gemini'],
                'touch-phone': ['gemini']
            }
        }
    ],
    I18N: {
        TANKER_PRJ: 'advertising-www',
        TANKER_API_TOKEN: 'OAuth ' + process.env.TANKER_OAUTH_TOKEN,
        TANKER_PRJ_REV: 'master',
        I18N_BLOCK_NAME: 'locale',
        I18N_LEVEL_PATH: 'meta.blocks',
        I18N_MODIFIER_NAME: 'keyset',
        I18N_KEYSET_DOWNLOAD_OPTS: 'all-form=true&status=unapproved'
    }
};
