'use strict';

let path = require('path');
let vfs = require('vow-fs');

function GeminiPlugin(taskName, config, options) {
    this._config = config;
    this._taskName = taskName;
    this._options = options;

    this._configurators = [];
    this._targets = [];

    this._configureTask();
}

GeminiPlugin.prototype._configureTask = function () {
    let config = this._config;
    let options = this._options;
    let taskName = this._taskName;
    let configurators = this._configurators;

    config.task(taskName, task => {
        configurators.forEach(configurator => {
            configurator(config);
        });

        return vfs.exists(options.destPath).then(exists => {
            if (exists) {
                return task.buildTarget(path.join(options.destPath, options.target));
            }
        });
    });
};

/**
 * @param {Function} configurator
 */
GeminiPlugin.prototype.addConfigurator = function (configurator) {
    this._configurators.push(configurator);
};

module.exports = GeminiPlugin;
