'use strict';

let path = require('path');
let Vow = require('vow');
let vowFs = require('vow-fs');
let borschik = require('borschik');

module.exports = require('enb/lib/build-flow').create()
    .name('priv-js')
    .target('target', '?.priv.js')
    .defineOption('privFile', '')
    .defineOption('mode', 'production')
    .useFileList(['priv.js'])
    .needRebuild(function (cache) {
        this._privFile = this._privFile ?
            path.join(this.node._root, this._privFile) :
            require.resolve('priv-js/lib/priv.js');

        return cache.needRebuildFile('priv-file', this._privFile);
    })
    .saveCache(function (cache) {
        cache.cacheFileInfo('priv-file', this._privFile);
    })
    .builder(function (privFiles) {

        let _this = this;
        let node = _this.node;
        let target = this._target;

        if (_this._mode === 'production') {

            let buildSource = function (item, pre, post) {
                return [
                    pre || '',
                    item,
                    post || ''
                ].join('\n');
            };

            return Vow.all(privFiles.map(file => {
                return _this.node.createTmpFileForTarget(target).then(tmpfile => {
                    let opts = {
                        input: file.fullname,
                        output: tmpfile,
                        freeze: false,
                        minimize: false
                    };
                    return Vow.when(borschik.api(opts)).then(() => {
                        return vowFs.read(tmpfile, 'utf8').then(data => {
                            vowFs.remove(tmpfile);
                            return data;
                        });
                    });
                });
            })).then(res => {
                return vowFs.read(_this._privFile, 'utf8')
                    .then(privFile => {
                        return [
                            buildSource(privFile, 'var Blocks = (function() {\nvar module = {}', 'return module.exports\n})();'),
                            'var blocks = new Blocks();',
                            res.map(item => {
                                return buildSource(item, '(function(blocks) {', 'module.exports(blocks)\n})(blocks);');
                            }).join('\n'),
                            'module.exports = blocks;'
                        ].join('\n');
                    });
            });

        } else {
            let buildRequire = function (absPath, pre, post) {
                let relPath = node.relativePath(absPath);
                return [
                    'delete require.cache[require.resolve("' + relPath + '")];',
                    (pre || '') + 'require("' + relPath + '")' + (post || '') + ';'
                ].join('\n');
            };
            return [
                buildRequire(this._privFile, 'var Blocks = '),
                'var blocks = new Blocks();',
                privFiles.map(file => {
                    return buildRequire(file.fullname, '', '(blocks)');
                }).join('\n'),
                'module.exports = blocks;'
            ].join('\n');
        }

    })
    .createTech();
