'use strict';

let makeConfig = require('./config');
let configurators = require('./node-configurators/');

module.exports = function (config) {
    require('./enb-tools')(config);

    config.module('enb-tools')
        .configureProject({
            libraries: makeConfig.LIBRARIES,
            platforms: makeConfig.PLATFORMS,
            languages: makeConfig.LANGUAGES,
            i18n: makeConfig.I18N,
            gemini: {
                configurator: configurators.gemini
            },
            bundles: {
                configurator: configurators.bundles
            }
        });
};
