'use strict';

let autoprefixerConfig = require('../../.autoprefixer.js');

function getBrowsers(platform, suffix) {
    let key = [platform, suffix].join(':');

    for (let mask in autoprefixerConfig) {
        if (new RegExp(mask).test(key)) {
            return autoprefixerConfig[mask];
        }
    }

    return autoprefixerConfig[platform + ':css'];
}

module.exports = {
    getBrowsers
};
