BEM.DOM.decl({ block: 'accordion', modName: 'type', modVal: 'storage' }, {
    onSetMod: {
        js: {
            inited: function () {
                this.__base.apply(this, arguments);

                this.elem('item').each(this._markItems.bind(this));
            }
        }
    },

    _onTitleClick: function (e) {
        this.__base.apply(this, arguments);

        this._storeItem(e);
    },

    /**
     * Помечает ссылку, как посещённую
     * @param {Object} _
     * @param {Object} item
     * @private
     */
    _markItems: function (_, item) {
        var $item = $(item);
        var storage = BEM.blocks['i-bem'].getStorage();
        var value = storage.get($item.attr('data-id'));

        if (value) {
            this.setMod($item, 'visited', 'yes');
        }
    },

    /**
     * Сохраняет ID элемента в Storage
     * @param {Object} e
     * @private
     */
    _storeItem: function (e) {
        var item = e.data.domElem;
        var $parent = item.parent();
        var storage = BEM.blocks['i-bem'].getStorage();

        storage.set($parent.attr('data-id'), 'yes');
        this.setMod($parent, 'visited', 'yes');
    }
});
