module.exports = function (bh) {
    bh.match('accordion', function (ctx, json) {
        var accordionId = json.accordionId;

        ctx
            .js({ goalId: json.goalId })
            .content(json.items.map(function (accordionItem, idx) {
                var itemId = accordionId && accordionId + '-' + idx;

                return accordionItem.title && {
                    elem: 'item',
                    attrs: itemId && { 'data-id': itemId },
                    accordionItem: accordionItem
                };
            }));
    });

    bh.match('accordion__item', function (ctx, json) {
        var accordionItem = json.accordionItem;
        var title = accordionItem.title;
        var items = accordionItem.items;
        var url = accordionItem.url;
        var hasItems = Boolean(items && items.length);
        var isFirst = ctx.isFirst() && 'yes';

        if (!title) {
            return '';
        }

        ctx
            .mods({ active: isFirst, visited: isFirst })
            .content([
                {
                    elem: 'title-wrapper',
                    mods: { clickable: hasItems },
                    content: [
                        { elem: 'arrow' },
                        {
                            elem: 'title',
                            tag: 'h3',
                            url: url,
                            title: title
                        }
                    ]
                },
                hasItems && {
                    elem: 'parameters',
                    mods: { hidden: 'yes' },
                    content: items.map(function (item) {
                        return {
                            elem: 'parameter',
                            url: item.url,
                            text: item.text,
                            image: item.image,
                            imageAlign: item.imageAlign
                        };
                    })
                }
            ]);
    });

    bh.match('accordion__arrow', function (ctx) {
        ctx.content({
            block: 'icon',
            mods: {
                direction: 'bottom',
                glyph: 'type-arrow'
            }
        });
    });

    /* eslint-disable complexity */
    bh.match('accordion__parameter', function (ctx, json) {
        var url = json.url;
        var text = json.text;
        var image = json.image;
        var imageAlign = json.imageAlign || 'left';

        if (url) {
            ctx.content({
                block: 'link',
                mods: { theme: 'normal' },
                url: url,
                content: text
            });
        } else {
            ctx.content([
                image && {
                    elem: 'parameter-image',
                    mods: { align: text && imageAlign },
                    tag: 'img',
                    attrs: {
                        alt: text,
                        title: text,
                        src: image
                    }
                },
                text && {
                    elem: 'parameter-text',
                    mods: { display: image && 'inline' },
                    mix: { block: 'html-content' },
                    content: text
                }
            ]);
        }
    });
    /* eslint-enable complexity */

    bh.match('accordion__title', function (ctx, json) {
        ctx.content(ctx.content() || json.title, true);
    });
};
