module.exports = function (bh) {
    bh.match('adaptive-form', function (ctx, json) {
        var data = json.data;
        var attrs = data.attrs || {};
        var params = data.params || {};

        var queryObject = Object.assign(
            {
                iframe: 1,
                theme: data.theme,
                'media-type': bh.lib.global.isMobile ? 'mobile' : 'desktop'
            },
            data.queryParams || {}
        );
        var url = data.url + '?' + joinObject(queryObject, '=', '&');

        ctx
            .js(params)
            .tag('iframe')
            .attrs(
                {
                    'data-iframe-type': 'form',
                    width: attrs.width || '100%',
                    height: attrs.height || '100%',
                    name: attrs.name || '',
                    frameborder: 0,
                    allowfullscreen: false,
                    src: url
                }
            );
    });

    function joinObject(object, fieldDelimiter, delimiter) {
        var queryParams = Object.keys(object).map(function(key) {
            if (!object[key]) {
                return '';
            }

            return key + fieldDelimiter + object[key];
        });

        return queryParams.join(delimiter);
    }
};
