BEM.DOM.decl('adaptive-form', {
    onSetMod: {
        js: {
            inited: function () {
                this._iframe = this.domElem;

                this.bindToWin('message', this._onIframeMessage.bind(this));
            }
        }
    },

    _onIframeMessage: function (event) {
        var data = event.originalEvent.data;
        var source = event.originalEvent.source;

        try {
            data = JSON.parse(data);
        } catch (err) {
            return;
        }

        this._onPingMessage(data, source);

        if (!this._isDataForCurrentForm(data)) {
            return;
        }

        this._onResizeMessage(data);

        this._onSendMessage(data);
    },

    _isDataForCurrentForm: function(data) {
        return data.name && data.name === this.params.name;
    },

    _onPingMessage: function(data, source) {
        /* eslint-disable max-len */
        // Iframe anti ClickJacking
        // https://github.yandex-team.ru/pages/yandex-events/yandex-tech-api-docs/docs.html#vstraivanie-formyi-v-iframe
        if (source && data.message === 'ping') {
            source.postMessage('pong', '*');
        }
    },

    _onResizeMessage: function(data) {
        // Через postMessage с интервалом в 300мс отправляется высота страницы
        // Меняем высоту iframe
        if (data['iframe-height'] && this.params.adaptive) {
            var pad = 0;

            if (this.params.name === 'journal-form') {
                pad = 2;
            }

            var height = data['iframe-height'];

            this._iframe.height(height + pad);
        }
    },

    _onSendMessage: function(data) {
        if (data.message === 'sent' && this.params.goal) {
            BEM.blocks.metrika.reachGoal(this.params.goal);
        }
    }
});
