module.exports = function (bh) {
    /* eslint-disable complexity */
    bh.match('agency-info', function (ctx) {
        var agency = ctx.param('agency');
        var address = agency.addresses[0];
        var isMobile = bh.lib.global.isMobile;

        if (isMobile) {
            ctx
                .tag('a')
                .attr('href', agency.url);
        } else {
            ctx.tag('article');
        }

        ctx
            .js(true)
            .content([
                {
                    elem: 'title',
                    content: agency.name
                },
                {
                    elem: 'icon',
                    tag: isMobile ? 'div' : 'a',
                    attrs: { href: !isMobile && agency.url },
                    content: {
                        block: 'image',
                        url: bh.lib.util.mds(agency.logo, 'a_logo_m'),
                        alt: ''
                    }
                },
                {
                    elem: 'contacts',
                    content: [
                        {
                            elem: 'item', mods: { type: 'address' },
                            content: address.address
                        },
                        {
                            elem: 'item', mods: { type: 'phone' },
                            content: bh.lib.i18n('agency', 'phone') + ': ' + address.phone
                        },
                        {
                            elem: 'item', mods: { type: 'site' },
                            content: [
                                bh.lib.i18n('agency', 'site') + ': ',
                                bh.lib.global.isMobile ? agency.site : {
                                    block: 'link',
                                    mods: { theme: 'normal' },
                                    target: '_blank',
                                    url: 'http://' + agency.site,
                                    content: agency.site
                                }
                            ]
                        }
                    ]
                },
                !isMobile && {
                    elem: 'foot',
                    content: {
                        block: 'link',
                        mods: { theme: 'gray' },
                        url: agency.url,
                        content: bh.lib.i18n('agency', 'readmore')
                    }
                }
            ]);
    });
    /* eslint-enable complexity */

    bh.match('agency-info__title', function (ctx) {
        ctx.tag('h2');
    });

    bh.match('agency-info__contacts', function (ctx) {
        ctx.tag('ul');
    });

    bh.match(['agency-info__item'], function (ctx) {
        ctx.tag('li');

        var content = ctx.content();

        if (ctx.isSimple(content) && content.length > 55) {
            ctx.attr('title', content);
        }
    });
};
