BEM.DOM.decl('agency-list', {
    onSetMod: {
        js: {
            inited: function () {
                this._list = this.findElem('list');

                this.__self.list = this;
            }
        }
    },

    /**
     * Добавляет в список переданные агентства
     * @param {Object []} agencies
     * @private
     */
    _append: function (agencies) {
        var entities = agencies
            .map(function (agency) {
                return {
                    block: 'agency-list',
                    elem: 'item',
                    content: {
                        block: 'agency-info',
                        agency: agency
                    }
                };
            });

        BEM.DOM.append(this._list, BH.apply(entities));
    },

    /**
     * Удаляет все агентства из списка
     * @private
     */
    _clear: function () {
        this._list.empty();
    }
}, {
    append: function (agencies) {
        this.list._append(agencies);
    },

    clear: function () {
        this.list._clear();
    }
});
