module.exports = function (blocks) {
    blocks.declare('agency-list', function (data) {
        var agencies = data.agenciesInfo && data.agenciesInfo.list;

        if (!agencies) {
            return '';
        }

        return {
            block: 'agency-list',
            content: agencies.map(function (agency) {
                return {
                    elem: 'item',
                    content: {
                        block: 'agency-info',
                        agency: agency
                    }
                };
            })
        };
    });
};
