module.exports = function (bh) {
    bh.match('agency', function (ctx, json) {
        var data = json.data;

        ctx
            .js(true)
            .tag('section')
            .content([
                Boolean(data.prevAgencyUrl) && {
                    elem: 'prev',
                    url: data.prevAgencyUrl
                },
                {
                    elem: 'content',
                    data: data.agency,
                    mapsApi: data.mapsApi.yandex
                },
                Boolean(data.nextAgencyUrl) && {
                    elem: 'next',
                    url: data.nextAgencyUrl
                },
                {
                    elem: 'modal',
                    agency: data.agency
                }
            ]);

        return [
            {
                block: 'list-link',
                mods: {
                    offset: 'yes'
                },
                url: data.agenciesUrl,
                text: bh.lib.i18n('agency', 'allagencies')
            },
            ctx.json()
        ];
    });

    bh.match('agency__modal', function (ctx, json) {
        var agency = json.agency;

        ctx.content({
            block: 'modal',
            mods: { theme: 'normal', autoclosable: 'yes' },
            content: {
                block: 'modal-content',
                title: bh.lib.i18n('agency', 'modal.title'),
                inner: {
                    block: 'contact-form',
                    js: {
                        agencyId: agency.site,
                        url: bh.lib.global.contactFormPath,
                        metrikaGoalId: 'send_request_to_agency',
                        formName: 'agency-form'
                    },
                    fields: [
                        {
                            type: 'input',
                            required: true,
                            label: bh.lib.i18n('agency', 'form.name'),
                            name: 'name'
                        },
                        {
                            type: 'email',
                            required: true,
                            label: bh.lib.i18n('agency', 'form.email'),
                            name: 'email'
                        },
                        {
                            type: 'textarea',
                            required: true,
                            label: bh.lib.i18n('agency', 'form.message'),
                            name: 'comment'
                        }
                    ],
                    button: {
                        text: bh.lib.i18n('agency', 'form.button')
                    }
                }
            }
        });
    });

    bh.match(['agency__prev', 'agency__next'], function () {
        if (bh.lib.global.isMobile) {
            return '';
        }
    });

    bh.match('agency__prev', function (ctx, json) {
        ctx
            .tag('a')
            .attr('href', json.url)
            .attr('title', bh.lib.i18n('agency', 'prev'));
    });

    bh.match('agency__next', function (ctx, json) {
        ctx
            .tag('a')
            .attr('href', json.url)
            .attr('title', bh.lib.i18n('agency', 'next'));
    });

    bh.match('agency__content', function (ctx, json) {
        ctx
            .mix({ block: 'clearfix' })
            .content([
                ctx.content(),
                {
                    elem: 'wrapper',
                    agency: json.data,
                    mapsApi: json.mapsApi
                }
            ], true);
    });

    bh.match('agency__wrapper', function (ctx, json) {
        var agency = json.agency;

        if (!agency) {
            return '';
        }

        var certificates = Object.keys(agency.certificates)
            .filter(function (type) {
                return agency.certificates[type];
            });

        ctx.content([
            {
                elem: 'title',
                content: agency.name
            },
            ctx.content(),
            certificates.length ? [
                {
                    elem: 'subtitle',
                    content: bh.lib.i18n('agency', 'certificates')
                },
                {
                    elem: 'certificates',
                    certificates: certificates
                }
            ] : '',
            agency.addresses.length ? [
                {
                    elem: 'subtitle',
                    content: bh.lib.i18n('agency', 'address')
                },
                {
                    elem: 'addresses',
                    addresses: agency.addresses,
                    mapsApi: json.mapsApi
                }
            ] : ''
        ], true);
    });

    bh.match('agency__left-column', function (ctx, json) {
        var agency = json.agency;

        if (!agency) {
            return '';
        }

        ctx.content([
            {
                elem: 'logo',
                agency: agency
            },
            agency.certificates && {
                elem: 'plate',
                certificates: agency.certificates,
                tag: 'img',
                attrs: {
                    src: bh.lib.i18n('agency', 'certificate_plate'),
                    alt: bh.lib.i18n('agency', 'certificate_title'),
                    title: bh.lib.i18n('agency', 'certificate_title')
                }
            },
            ctx.content(),
            {
                elem: 'info',
                agency: agency
            },
            { elem: 'button-send' }
        ], true);
    });

    bh.match('agency__info', function (ctx, json) {
        var agency = json.agency;

        if (!agency) {
            return '';
        }

        ctx.content([
            {
                elem: 'site',
                content: [
                    bh.lib.i18n('agency', 'site') + ': ',
                    {
                        block: 'link',
                        mods: { theme: 'normal' },
                        target: '_blank',
                        url: 'http://' + agency.site,
                        content: agency.site
                    }
                ]
            },
            agency.emails.map(function (email) {
                return {
                    elem: 'email',
                    content: [
                        bh.lib.i18n('agency', 'email') + ': ',
                        {
                            block: 'link',
                            mods: { theme: 'normal' },
                            url: 'mailto:' + email,
                            content: email
                        }
                    ]
                };
            })
        ]);
    });

    bh.match('agency__button-send', function (ctx) {
        ctx.content({
            block: 'button',
            mods: { theme: 'action', size: 'm' },
            content: bh.lib.i18n('agency', 'feedback')
        });
    });

    bh.match('agency__plate', function (ctx, json) {
        var result = false;

        for (var key in json.certificates) {
            if (json.certificates[key]) {
                result = true;
            }
        }

        if (!result) {
            return '';
        }
    });

    bh.match('agency__title', function (ctx) {
        ctx.tag('h1');
    });

    bh.match('agency__subtitle', function (ctx) {
        ctx.tag('h2');
    });

    bh.match('agency__certificates', function (ctx, json) {
        var certificates = json.certificates;

        var result = certificates
            .map(function (type) {
                return {
                    block: 'agency-certificate',
                    type: type
                };
            });

        ctx.content(result);
    });

    bh.match('agency__addresses', function (ctx, json) {
        var addresses = json.addresses;
        var mapsApi = json.mapsApi;

        var result = addresses.map(function (address) {
            return {
                elem: 'address',
                content: [
                    {
                        elem: 'map-wrapper',
                        content: mapsApi && address.map && {
                            block: 'map',
                            js: {
                                mapsApi: mapsApi,
                                address: address.map
                            }
                        }
                    },
                    {
                        elem: 'address-text',
                        content: [
                            address.address,
                            '<br>',
                            bh.lib.i18n('agency', 'phone') + ': ' + address.phone
                        ]
                    }
                ]
            };
        });

        ctx.content(result);
    });

    bh.match('agency__logo', function (ctx, json) {
        var agency = json.agency;

        if (!agency) {
            return '';
        }

        ctx.content([
            {
                tag: 'img',
                attrs: {
                    alt: agency.name,
                    title: agency.title,
                    src: bh.lib.util.mds(agency.logo, 'a_logo_l')
                }
            }
        ]);
    });
};
