module.exports = function (blocks) {
    blocks.declare('b-page_type_ad-products', function (data) {
        var product = data.product;
        var sections = data.sections;
        var queryParams = data.queryParams;

        var pageContent = {
            block: 'page-content',
            content: [
                product && {
                    block: 'poster',
                    data: product,
                    queryParams: queryParams
                },
                sections.map(function (section) {
                    section.page = data.section;

                    return section;
                })
            ]
        };

        var mainLayout = {
            block: 'main-layout',
            mods: {
                'from-top': true
            }
        };

        if (data.menu) {
            mainLayout.right = pageContent;
        } else {
            mainLayout.content = pageContent;
        }

        return [
            mainLayout,
            blocks.exec('levels', data)
        ];
    });
};
