module.exports = function (blocks) {
    var pageData = {
        agencies: function (data) {
            return [
                {
                    elem: 'title',
                    content: data.agencySearch.title
                },
                {
                    elem: 'text',
                    content: data.agencySearch.description
                }
            ];
        },
        offices: function (data) {
            var offices = data.offices;

            return [
                {
                    elem: 'title',
                    content: offices.title
                },
                {
                    elem: 'text',
                    content: offices.description
                },
                blocks.exec('offices', data)
            ];
        },
        support: function (data) {
            var supportData = data.support;

            return [
                {
                    elem: 'title',
                    content: supportData.title
                },
                {
                    elem: 'text',
                    content: [
                        supportData.description,
                        supportData.sections.map(function (section) {
                            return [
                                {
                                    elem: 'subtitle',
                                    content: section.title
                                },
                                {
                                    tag: 'p',
                                    content: section.description
                                },
                                {
                                    block: 'support-contacts',
                                    contacts: section.phones,
                                    form: section.feedback,
                                    js: {
                                        isForm: section.feedback.type === 'form'
                                    }
                                }
                            ];
                        }),
                        supportData.footer
                    ]
                }
            ];
        }
    };

    blocks.declare('b-page_type_contacts', function (data) {
        var page = data.page;

        return {
            block: 'main-layout',
            right: {
                block: 'page-content',
                content: pageData[page](data)
            },
            tail: [
                page === 'agencies' && [
                    blocks.exec('search-filter', data),
                    blocks.exec('agency-list', data)
                ]
            ]
        };
    });
};
