module.exports = function (blocks) {
    blocks.declare('b-page_type_events', function (data) {
        var eventsPage = data.eventsPage;

        return [
            {
                block: 'main-layout',
                right: {
                    block: 'page-content',
                    content: [
                        {
                            elem: 'title',
                            mods: { text: 'left' },
                            content: eventsPage.title
                        },
                        {
                            elem: 'text',
                            content: eventsPage.description
                        },
                        eventsPage.additionalText && {
                            elem: 'text',
                            mods: { offset: 'top' },
                            content: eventsPage.additionalText
                        }
                    ]
                },
                tail: [
                    blocks.exec('events-filter', data),
                    blocks.exec('events-list', data)
                ]
            },
            blocks.exec('levels', data)
        ];
    });
};
