module.exports = function (blocks) {
    /* eslint-disable complexity */
    blocks.declare('b-page_type_experts', function (data) {
        var expertsPage = data.expertsPage;
        var expertsFilters = data.expertsFilters;
        var hasCities = expertsFilters && expertsFilters.cities && expertsFilters.cities.length;
        var hasSpecializations = expertsFilters
            && expertsFilters.specializations
            && expertsFilters.specializations.length;

        return [
            {
                block: 'main-layout',
                right: {
                    block: 'page-content',
                    content: [
                        {
                            block: 'experts-page',
                            expertsPage: expertsPage,
                            hasFilters: hasCities || hasSpecializations
                        }
                    ]
                },
                tail: [
                    blocks.exec('experts-filter', data),
                    blocks.exec('experts-list', data)
                ]
            },
            blocks.exec('levels', data)
        ];
    });
    /* eslint-enable complexity */
};
