module.exports = function (blocks) {
    blocks.declare('b-page_type_freelancers', function (data) {
        return [
            {
                block: 'main-layout',
                right: {
                    block: 'page-content',
                    content: {
                        block: 'experts-page',
                        expertsPage: Object.assign({
                            imageUrl: data.image
                        }, data),
                        hasFilters: false
                    }
                },
                tail: [
                    {
                        block: 'filters',
                        items: data.filters,
                        searchUrl: data.searchUrl,
                        scrollToFilters: data.scrollToFilters
                    },
                    blocks.exec('experts-list', Object.assign({
                        expertsData: {
                            experts: data.freelancers,
                            expertSlugToUrl: data.expertSlugToUrl
                        }
                    })),
                    {
                        block: 'agency-disclaimer',
                        mods: { type: 'freelancers' },
                        text: data.disclaimer
                    }
                ]
            },
            blocks.exec('levels', data)
        ];
    });
};
