module.exports = function (blocks) {
    blocks.declare('b-page_type_journals', function (data) {
        var headerData = data.metaData.title;
        var journals = data.list || [];

        return [
            {
                block: 'main-layout',
                content: [
                    {
                        block: 'page-content',
                        content: [
                            {
                                elem: 'title',
                                content: headerData.title
                            },
                            headerData.description && {
                                elem: 'text',
                                mix: { block: 'html-content' },
                                text: headerData.description
                            }
                        ]
                    },
                    {
                        block: 'filters',
                        mods: { theme: 'journals' },
                        items: data.filters,
                        searchUrl: data.searchUrl,
                        size: 'm'
                    },
                    {
                        block: 'journals',
                        filterUrl: data.filterUrl,
                        items: journals,
                        data: data
                    }
                ]
            },
            blocks.exec('levels', data)
        ];
    });
};
