module.exports = function (blocks) {
    blocks.declare('b-page_type_lesson', function (data) {
        var storage = data.storage;
        var pageBlocks = data.blocks;
        var titlePrefix = storage.titlePrefix;
        var hasPageBlocks = pageBlocks && pageBlocks.length > 0;

        if (!storage) {
            return '';
        }

        var navigation = {
            block: 'lesson-navigation',
            data: {
                prev: data.prevLesson,
                next: data.nextLesson,
                listLink: data.lessonsLink
            }
        };

        return [
            {
                block: 'main-layout',
                attrs: {
                    itemscope: true,
                    itemtype: 'http://schema.org/Article'
                },
                content: {
                    block: 'page-content',
                    content: [
                        {
                            tag: 'meta',
                            attrs: {
                                itemprop: 'identifier',
                                content: storage.slug
                            }
                        },
                        {
                            elem: 'title',
                            mods: { text: 'left' },
                            content: [
                                titlePrefix && [
                                    titlePrefix,
                                    ' '
                                ],
                                storage.title
                            ],
                            attrs: {
                                itemprop: 'headline'
                            }
                        },
                        Object.assign({ mods: { type: 'top' } }, navigation),
                        hasPageBlocks && [
                            {
                                block: 'lesson-content',
                                blocks: pageBlocks,
                                contentText: storage.contentText,
                                metrikaGoalId: storage.metrikaGoalId
                            },
                            {
                                block: 'lesson-body',
                                attrs: {
                                    itemprop: 'articleBody'
                                },
                                content: pageBlocks.map(function (block) {
                                    return {
                                        block: 'lesson-block',
                                        mods: { type: block.type },
                                        data: Object.assign({
                                            lessonLink: data.lessonsLink + '-' + storage.slug
                                        }, block)
                                    };
                                })
                            },
                            Object.assign({ mods: { type: 'bottom' } }, navigation)
                        ]
                    ]
                }
            },
            blocks.exec('levels', data)
        ];
    });
};
