module.exports = function (blocks) {
    blocks.declare('b-page_type_news-list', function (data) {
        var titleData = data.title;
        var filtersLayout = data.isTouch ? 'content' : 'auto';

        return [
            {
                block: 'main-layout',
                content: [
                    {
                        block: 'news-header',
                        data: titleData
                    },
                    {
                        block: 'news-selects-filters',
                        mods: { layout: filtersLayout },
                        data: data
                    },
                    data.journal && {
                        block: 'level',
                        mods: { type: 'journal' },
                        url: data.url,
                        level: data.journal,
                        page: data.page,
                        comdiUrl: data.comdiUrl,
                        newsPage: data.newsPage,
                        browserName: data.browserName,
                        commentsData: data.commentsData,
                        journalsPage: data.journalsPage,
                        isBrowserValid: data.isBrowserValid,
                        transactionPath: data.transactionPath
                    },
                    {
                        block: 'news-list',
                        data: data
                    }
                ]
            }
        ];
    });
};
