module.exports = function (blocks) {
    blocks.declare('b-page_type_partners-news', function (data) {
        var titleData = data.title;

        return [
            {
                block: 'main-layout',
                mods: { wide: 'yes' },
                left: null,
                right: data.post ? {
                    block: 'news-info',
                    mods: { type: 'post' },
                    elem: 'post',
                    post: data.post,
                    blogUrl: data.blog.blogUrl,
                    articleCta: data.articleCta
                } : [
                    {
                        block: 'page-content',
                        content: [
                            {
                                elem: 'title',
                                content: titleData.title
                            },
                            titleData.description && {
                                elem: 'text',
                                mix: { block: 'html-content' },
                                text: titleData.description
                            }
                        ]
                    },
                    {
                        block: 'partners-info',
                        mods: { page: 'news' },
                        data: data
                    }
                ]
            },
            blocks.exec('levels', data)
        ];
    });
};
