module.exports = function (blocks) {
    blocks.declare('b-page_type_products', function (data) {
        var product = data.product;
        var sections = data.sections;

        var pageContent = {
            block: 'page-content',
            content: [
                product.title && {
                    elem: 'title',
                    content: product.title
                },
                product.text && {
                    elem: 'text',
                    mix: { block: 'html-content' },
                    image: product.image,
                    imageWidth: product.imageWidth,
                    imageAlign: product.imageAlign,
                    text: product.text
                },
                sections.map(function (section) {
                    section.page = data.section;

                    return section;
                })
            ]
        };

        var mainLayout = {
            block: 'main-layout'
        };

        if (data.menu) {
            mainLayout.right = pageContent;
        } else {
            mainLayout.content = pageContent;
        }

        return [
            mainLayout,
            blocks.exec('levels', data)
        ];
    });
};
