module.exports = function (blocks) {
    blocks.declare('b-page_type_requirements', function (data) {
        return {
            block: 'main-layout',
            mods: { type: 'wide' },
            pageTitle: 'requirements',
            data: data,
            left: !data.isMainPage && [
                {
                    block: 'pseudo-menu',
                    mods: { margin: 'bottom' },
                    items: data.sectionInfo.legals
                },
                {
                    block: 'left-menu',
                    data: {
                        menu: data.menu
                    }
                },
                {
                    block: 'pseudo-menu',
                    mods: { margin: 'top' },
                    items: data.sectionInfo.recommendations
                }
            ],
            right: !data.isMainPage && [
                {
                    block: 'requirements-info',
                    mods: { page: 'nested' },
                    data: data
                }
            ],
            content: data.isMainPage && [
                {
                    block: 'requirements-info',
                    mods: { page: 'main' },
                    data: data
                }
            ]
        };
    });
};
