module.exports = function (bh) {
    bh.match('b-page', function (ctx) {
        var title = ctx.param('metaTitle');
        var titleText = '';

        if (title && title.key) {
            titleText = bh.lib.i18n('pages', title.key);
        } else if (title && title.text) {
            titleText = title.text;
        }

        ctx
            .mix({
                block: 'i-font',
                mods: {
                    face: [
                        'ys-text-light',
                        'ys-text-regular',
                        'ys-text-medium',
                        'ys-text-bold',
                        'ys-display-regular',
                        'ys-display-medium'
                    ]
                }
            })
            .param('title', titleText);

        bh.lib.global.makePublic({
            browser: true,
            contactFormPath: true,
            subscribeFormPath: true,
            isTouch: true,
            isMobile: true,
            OSFamily: true,
            regions: true,
            'secret-key': true,
            pageType: true,
            shareServices: true,
            siteSearchUrl: true,
            refreshCaptchaUrl: true,
            nonce: true,
            htmlMappings: true
        });
    });
};
