module.exports = function (blocks) {
    /* eslint-disable max-len, complexity */
    var getCta = function (data) {
        return data.product && data.product.cta;
    };

    var getPhoneData = function (data) {
        if (data.product && data.product.phone) {
            return {
                phone: data.product.phone.number,
                text: data.product.phone.hint
            };
        }

        return data.settings.footer;
    };

    var getSidebarPusher = function (data, page) {
        var openMenu = data.mainMenu.openMenu;

        return {
            block: 'sidebar-pusher',
            mods: {
                pushed: openMenu && 'yes'
            },
            content: [
                blocks.exec('b-page_type_' + page, data),
                { block: 'debug', data: data },
                blocks.exec('media', data),
                blocks.exec('prefooter', data),
                blocks.exec('footer', data)
            ]
        };
    };

    blocks.declare('b-page', function (data, page) {
        var login = data.blackbox && data.blackbox.displayName || '';
        var uid = data.blackbox && data.blackbox.uid || '';
        var bundleName = page === 'index' ? 'index' : 'common';
        var bundlePlatform = data.bundlePlatform;
        var isMobile = bundlePlatform === 'touch-phone';
        var staticSuffix = data.stNoCache && typeof Date.now === 'function' ? `?v=${Date.now()}` : '';

        return [
            {
                block: 'i-global',
                params: {
                    lang: data.language,
                    tld: data.tld,
                    userEmail: data.userInfo.email,
                    'content-region': data.contentRegion,
                    'secret-key': data.secretKey,
                    retpath: data.url,
                    host: `https://${data.host}`,
                    id: 'adv-www',
                    homeUrl: data.homeUrl,
                    login: login,
                    uid: uid,
                    formsUrl: data.formsUrl,
                    query: data.query,
                    contactFormPath: data.contactFormPath,
                    subscribeFormPath: data.subscribeFormPath,
                    browser: data.uatraits.BrowserName,
                    nonce: data.nonce,
                    yandexuid: data.yandexuid,
                    'passport-host': data.passportHost,
                    isTouch: data.isTouch,
                    isMobile: data.uatraits.isMobile,
                    OSFamily: data.uatraits.OSFamily,
                    regions: data.regions,
                    pageType: page,
                    shareServices: data.shareServices,
                    siteSearchUrl: data.siteSearchUrl,
                    refreshCaptchaUrl: data.refreshCaptchaUrl,
                    htmlMappings: data.htmlMappings
                }
            },
            {
                block: 'b-page',
                page: page,
                js: {
                    timeGoals: [
                        data.tld === 'cn' && 'time30'
                    ]
                },
                metaTitle: { text: data.seo.title },
                head: [
                    {
                        elem: 'css',
                        url: `${data.stHost}/${bundlePlatform}.bundles/${bundleName}/_${bundleName}.css${staticSuffix}`,
                        ie: false
                    },
                    !isMobile && {
                        elem: 'css',
                        url: `${data.stHost}/${bundlePlatform}.bundles/${bundleName}/_${bundleName}`,
                        ie: true
                    },

                    { elem: 'favicon', url: data.faviconUrl },

                    { elem: 'meta', attrs: { name: 'description', content: data.seo.description } },
                    { elem: 'meta', attrs: { name: 'keywords', content: data.seo.keywords } },
                    data.og && {
                        block: 'og',
                        og: data.og
                    },
                    {
                        elem: 'meta',
                        attrs: {
                            name: 'viewport',
                            content: 'width=device-width' + (isMobile ? ',minimum-scale=1,maximum-scale=1,' +
                                                                        'initial-scale=1,user-scalable=no' : '')
                        }
                    },
                    isMobile && [
                        {
                            elem: 'meta',
                            attrs: {
                                name: 'format-detection',
                                content: 'telephone=no'
                            }
                        },
                        {
                            elem: 'meta',
                            attrs: {
                                name: 'mobile-web-app-capable',
                                content: 'yes'
                            }
                        },
                        {
                            elem: 'meta',
                            attrs: { name: 'theme-color', content: '#fc3f1d' }
                        }
                    ],
                    data.instantArticlesPageId && {
                        elem: 'meta',
                        attrs: {
                            property: 'fb:pages',
                            content: data.instantArticlesPageId
                        }
                    },
                    data.meta.noindex && { elem: 'meta', attrs: { name: 'robots', content: 'noindex' } }
                ],
                'x-ua-compatible': 'IE=edge',
                mods: {
                    type: page
                },
                content: [
                    {
                        elem: 'wrapper',
                        data: data,
                        content: [
                            {
                                block: 'sidebar',
                                phoneData: getPhoneData(data),
                                cta: getCta(data),
                                siteSearchUrl: data.siteSearchUrl
                            },
                            {
                                block: 'sidebar-dimmer'
                            },
                            getSidebarPusher(data, page)
                        ]
                    },
                    !isMobile && {
                        elem: 'cc',
                        condition: 'IE 8',
                        content: { elem: 'js', url: 'https://yastatic.net/es5-shims/0.0.1/es5-shims.min.js' }
                    },
                    { elem: 'js', url: 'https://yastatic.net/jquery/1.11.3/jquery.min.js' },
                    page === 'lesson' && { elem: 'js', url: 'https://an.yandex.ru/system/context.js' },
                    {
                        elem: 'js',
                        url: `${data.stHost}/${bundlePlatform}.bundles/${bundleName}/_${bundleName}.${data.language}.js${staticSuffix}`
                    },
                    blocks.exec('scripts-loader', data),
                    blocks.exec('metrika', data),
                    data.adroll && {
                        tag: 'iframe',
                        attrs: { src: data.adroll, style: 'display: none;' }
                    }
                ]
            }
        ];
    });
};
