module.exports = function (bh) {
    var SERVICES_VIEW = {
        ru: [
            ['events', 'science', 'edu'],
            ['company', 'blog', 'vacancies', 'tech', 'adv']
        ],
        com: [
            ['company', 'vacancies', 'tech', 'adv', 'events']
        ],
        'com.tr': [
            ['company', 'blog', 'vacancies', 'tech', 'adv']
        ],
        by: [
            ['company', 'blog', 'vacancies', 'adv']
        ],
        kz: [
            ['company', 'blog', 'vacancies', 'adv']
        ],
        cn: [
            ['adv']
        ]
    };

    var SERVICES_URL = {
        company: {
            ru: '//yandex.ru/company/',
            com: '//yandex.com/company/',
            kz: '//yandex.kz/company/',
            by: '//yandex.by/company/',
            'com.tr': '//yandex.com.tr/company/'
        },
        vacancies: {
            ru: '//yandex.ru/jobs/',
            com: '//yandex.com/jobs',
            kz: '//yandex.ru/jobs/',
            by: '//yandex.by/jobs/',
            'com.tr': '//yandex.com.tr/jobs'
        },
        tech: {
            ru: '//tech.yandex.ru',
            com: '//tech.yandex.com',
            kz: '//tech.yandex.ru',
            by: '//tech.yandex.ru',
            'com.tr': '//tech.yandex.com.tr'
        },
        events: {
            ru: '//events.yandex.ru',
            com: '//events.yandex.com/events/',
            kz: '//events.yandex.ru',
            by: '//events.yandex.ru',
            'com.tr': '//events.yandex.com/events/'
        },
        science: {
            ru: '//research.yandex.ru',
            com: '//events.yandex.com/research/',
            kz: '//research.yandex.ru',
            by: '//research.yandex.ru',
            'com.tr': '//events.yandex.com/research/'
        },
        edu: {
            ru: '//academy.yandex.ru',
            kz: '//academy.yandex.ru',
            by: '//academy.yandex.ru'
        },
        blog: {
            ru: '//yandex.ru/blog/company',
            kz: '//yandex.kz/blog/company',
            by: '//yandex.by/blog/company',
            com: '//yandex.com/blog/company',
            'com.tr': '//yandex.com.tr/blog/company'
        }
    };

    bh.lib.getHeaderMenu = function (region) {
        var view = SERVICES_VIEW[region];

        return view.map(function (level) {
            return level.map(function (serviceId) {
                var isCurrent = serviceId === 'adv';

                return {
                    name: bh.lib.i18n('header', 'service.' + serviceId),
                    current: isCurrent,
                    url: isCurrent ? bh.lib.global.homeUrl : SERVICES_URL[serviceId][region]
                };
            });
        });
    };
};
