module.exports = function (bh) {
    bh.match('calendar', function (ctx) {
        var blog = ctx.param('blog');
        var options = {
            calendar: blog.calendar,
            postsCount: blog.postsCount,
            currentPath: ctx.param('currentPath')
        };
        var numberOfYears = options.calendar.current.year - options.calendar.start.year;

        ctx.js({
            slideWidth: 178,
            calendar: options.calendar,
            numberOfYears: numberOfYears
        });

        ctx.content([
            {
                elem: 'container',
                content: {
                    elem: 'list',
                    options: options
                }
            },
            numberOfYears && [
                /* eslint-disable max-len */
                {
                    elem: 'arrow-right',
                    mods: {
                        hidden: options.calendar.current.year === options.calendar.checked.year && 'yes'
                    }
                },
                {
                    elem: 'arrow-left',
                    mods: {
                        hidden: options.calendar.start.year === options.calendar.checked.year && 'yes'
                    }
                }
            ]
        ]);
    });

    bh.match('calendar__list', function (ctx) {
        var options = ctx.param('options');
        var content = [];

        var currentYear = options.calendar.current.year;
        var startYear = options.calendar.start.year;

        for (var year = startYear; year <= currentYear; year += 1) {
            content.push({
                elem: 'item',
                year: year,
                options: options
            });
        }

        ctx.content(content);
    });

    bh.match('calendar__item', function (ctx) {
        var year = ctx.param('year');

        ctx.content([
            {
                elem: 'year',
                content: year
            },
            {
                elem: 'months-list',
                year: year,
                options: ctx.param('options')
            }
        ]);
    });

    /* eslint-disable complexity */
    bh.match('calendar__months-list', function (ctx) {
        var content = [];
        var options = ctx.param('options');
        var year = ctx.param('year');
        var cal = options.calendar;

        var currentYear = cal.current.year;
        var lastMonth = year === currentYear && cal.current.month;
        var checkedMonth = year === cal.checked.year && cal.checked.month;
        var curYearPosts = options.postsCount[year] || {};

        for (var month = 1; month <= 12; month += 1) {
            content.push({
                elem: 'month',
                month: month,
                year: year,
                isCurrent: lastMonth && month === lastMonth,
                isChecked: checkedMonth && month === checkedMonth,
                isDisabled: !curYearPosts[cal.MONTH_DICTIONARY[month - 1]],
                content: bh.lib.i18n('i-tanker__months', 'n' + month),
                options: options
            });
        }
        ctx.content(content);
    });

    bh.match('calendar__month', function (ctx) {
        var isDisabled = ctx.param('isDisabled');
        var isChecked = ctx.param('isChecked');
        var isCurrent = ctx.param('isCurrent');
        var options = ctx.param('options');
        var year = ctx.param('year');
        var month = ctx.param('month');

        ctx.mods({
            disabled: isDisabled,
            checked: isChecked,
            current: isCurrent
        });

        if (!isDisabled && !isChecked) {
            ctx
                .tag('a')
                .attrs({
                    href: bh.lib.util.placeholder('{s}?year={s}&month={s}',
                        options.currentPath, year, options.calendar.MONTH_DICTIONARY[month - 1]
                    )
                });
        }
    });
};
