BEM.DOM.decl('calendar', {
    onSetMod: {
        js: function () {
            this._currentPos = 0;
            this._slideWidth = this.params.slideWidth;
            this._numberOfYears = this.params.numberOfYears;
            this._singleSlide = this._numberOfYears === 0;

            this._list = this.findElem('list');
            this._arrowLeft = this.findElem('arrow-left');
            this._arrowRight = this.findElem('arrow-right');

            this._initCarousel();
        }
    },

    _initCarousel: function () {
        var currentYear = this.params.calendar.current.year;
        var checkedYear = this.params.calendar.checked.year;

        this._initialNumberCheckedYear = currentYear - checkedYear;
        this._initialCheckedMonth = this.params.calendar.checked.month;
        if (this._initialCheckedMonth) {
            this._moveTo(this._initialNumberCheckedYear);
        }

        if (!this._singleSlide) {
            this._bindEvents();
        }
    },

    _bindEvents: function () {
        this.bindTo(this._arrowLeft, 'pointerclick', function () {
            this._moveTo(this._currentPos + 1);
        });
        this.bindTo(this._arrowRight, 'pointerclick', function () {
            this._moveTo(this._currentPos - 1);
        });
    },

    /**
     * Двигает слайдер на нужный слайд
     * @param {Number} n
     * @private
     */
    _moveTo: function (n) {
        if (n === this._currentPos || this._singleSlide) {
            return;
        }

        var slideOffset = -this._slideWidth * n;

        this._switchArrowVisible('right', n > 0);
        this._switchArrowVisible('left', n < this._numberOfYears);

        this._list.css('right', slideOffset);
        this._currentPos = n;
    },

    /**
     * Переключает стрелки видимые/невидимые
     * @param {String} direction
     * @param {Boolean} on
     * @private
     */
    _switchArrowVisible: function (direction, on) {
        var arrow = direction === 'left' ? this._arrowLeft : this._arrowRight;

        this.setMod(arrow, 'hidden', on ? 'no' : 'yes');
    }
});
