module.exports = function (bh) {
    bh.match('captcha', function (ctx, json) {
        ctx
            .js({
                refreshCaptchaUrl: json.refreshCaptchaUrl,
                silent: json.silent
            })
            .content([
                {
                    elem: 'body',
                    content: [
                        {
                            elem: 'img'
                        }
                    ]
                },
                {
                    elem: 'check',
                    content: [
                        {
                            elem: 'text',
                            content: bh.lib.i18n('forms', 'captcha')
                        },
                        {
                            block: 'input',
                            mods: { size: 's', theme: 'normal' },
                            content: { elem: 'control' }
                        },
                        {
                            elem: 'change',
                            content: {
                                block: 'button2',
                                mods: { size: 's', theme: 'normal' },
                                text: bh.lib.i18n('forms', 'captcha.change')
                            }
                        }
                    ]
                }
            ]);
    });

    bh.match('captcha__img', function (ctx) {
        ctx.tag('img');
    });

    bh.match('captcha__cover', function (ctx) {
        ctx.content({
            block: 'spin2',
            mods: {
                size: 'm',
                progress: 'yes'
            }
        });
    });
};
