BEM.DOM.decl('captcha', {
    onSetMod: {
        js: {
            inited: function () {
                this._key = null;
                this._image = this.findElem('img');
                this._input = this.findBlockInside('input');
                this._inputElem = this._input.findElem('control');
                this._changeButton = this.findBlockInside('button2');
                this._body = this.findElem('body');

                this._input.on('change', this._onInputChange.bind(this));
                this.bindTo(this._changeButton.domElem, 'click', this._refresh.bind(this));
            }
        }
    },

    _onInputChange: function () {
        this.trigger('captcha-input-change');
    },

    enable: function () {
        this._changeButton.delMod('disabled');
        this._input.delMod('disabled');
    },

    disable: function () {
        this._changeButton.setMod('disabled', 'yes');
        this._input.setMod('disabled', 'yes');
    },

    isVisible: function () {
        return this.hasMod('visible', 'yes');
    },

    hasValue: function () {
        return /\S/.test(this._input.val());
    },

    getValue: function () {
        return this._input.val();
    },

    setValue: function (value) {
        this._input.val(value);
    },

    getKey: function () {
        return this._key;
    },

    setKey: function (value) {
        this._key = value;
    },

    setSrc: function (src) {
        this._image.attr('src', src);
    },

    show: function (captcha) {
        if (captcha) {
            this.setKey(captcha.key);
            this.setSrc(captcha.src);
        }

        this.setMod('visible', 'yes');
        this._focus();
    },

    hide: function () {
        this.delMod('visible');
    },

    reset: function () {
        this.hide();
        this._key = null;
        this.setValue('');
        this.setSrc('');
    },

    _refresh: function () {
        this._runSpinner();
        this.disable();

        $.ajax({
            type: 'GET',
            url: this.params.refreshCaptchaUrl,
            dataType: 'json',
            contentType: 'application/json'
        })
            .done(this._changeCaptcha.bind(this))
            .fail(this._onError.bind(this));
    },

    _changeCaptcha: function (captcha) {
        this.show(captcha);
        this._detachCover();
        this.enable();
        this._focus();
    },

    _focus: function () {
        if (!this.params.silent) {
            this._inputElem.focus();
        }
    },

    _runSpinner: function () {
        BEM.DOM.append(this._body, BH.apply({
            block: 'captcha',
            elem: 'cover'
        }));
    },

    _onError: function (err) {
        var failMessage = BH.lib.util.errors.getCommentsErrorText('load-captcha', err);

        BEM.blocks['notifications-list'].notify(failMessage);
    },

    _detachCover: function () {
        var cover = this.findElem('cover');

        if (cover) {
            cover.detach();
        }
    }
});
