module.exports = function (bh) {
    bh.match('cards-block', function (ctx, json) {
        var data = json.data;
        var brand = data.brand;
        var link = data.link;

        ctx.content(data.enabled && [
            (brand || link.url) && {
                elem: 'head',
                brand: brand,
                link: link
            },
            {
                elem: 'cards',
                cards: [data.item1, data.item2, data.item3]
            }
        ]);
    });

    bh.match('cards-block__head', function (ctx, json) {
        var brand = json.brand;

        ctx.content([
            brand && {
                elem: 'brand',
                content: brand
            },
            ctx.content()
        ], true);
    });

    bh.match('cards-block__cards', function (ctx, json) {
        ctx.content(json.cards.map(function (card) {
            return {
                elem: 'card',
                card: card
            };
        }));
    });

    bh.match('cards-block__card', function (ctx, json) {
        var card = json.card;

        ctx.content({
            block: 'case-card',
            data: card
        });
    });
};
