module.exports = function (bh) {
    bh.match('case-card', function (ctx, json) {
        var data = json.data;
        var url = data.url;
        var image = data.image;
        var title = data.title;
        var theme = data.theme;

        ctx.content([
            image && {
                block: 'link',
                mods: { theme: 'black' },
                url: url,
                content: {
                    block: 'case-card',
                    elem: 'image-overlay',
                    content: {
                        elem: 'image-wrapper',
                        content: {
                            elem: 'image',
                            tag: 'img',
                            attrs: {
                                src: image,
                                alt: title,
                                title: title
                            }
                        }
                    }
                }
            },
            title && {
                elem: 'title',
                tag: 'h3',
                content: {
                    block: 'link',
                    mods: { theme: 'black' },
                    url: url,
                    content: title
                }
            },
            theme && {
                elem: 'theme',
                content: theme
            }
        ]);
    });
};
