module.exports = function (bh) {
    /* eslint-disable complexity */
    bh.match('chart-tooltip_type_dashboard', function (ctx, json) {
        var data = json.data;

        ctx.content([
            data.category && {
                elem: 'category',
                content: bh.lib.i18n('dashboard', 'cat.' + data.category)
            },
            data.title && {
                elem: 'title',
                content: data.title
            },
            data.info && {
                elem: 'categories',
                content: data.info
            },
            {
                elem: 'date',
                content: data.date
            },
            {
                elem: 'percent',
                mods: { arrow: data.percent > 0 ? 'top' : 'bottom' },
                content: (data.percent > 0 ? '+' : '') + data.percent + '%'
            }
        ]);
    });
    /* eslint-enable complexity */
};
