BEM.decl({
    block: 'chart',
    modName: 'type',
    modVal: 'modal'
}, {
    onSetMod: {
        js: {
            inited: function () {
                this._CHART_HEIGHT = 318;
                this._ANIMATION_DURATION = 400;
                this._PADDING = { top: 26, left: 40, right: 40 };
                this._TAIL = 14;
                this._MAP_HEIGHT = 30;
                this._LINES_OFFSET = { x: -40, y: 0 };
                this._MAP_OFFSET = { x: 30, y: 385 };
                this._MAP_TEXT_OFFSET = { from: { x: -20, y: -5 }, to: { x: -20, y: 50 } };

                this.__base.apply(this, arguments);
            }
        }
    },

    _prepareData: function (opts) {
        opts = opts || {};
        var data = opts.data || this.params.data;

        this._legend = opts.legend || this.params.legend;
        this._compareData = opts.compareData || this.params.compareData;
        this.currentData = data.map(function (point, index) {
            var newPoint = {};

            if (!(point.date instanceof Date)) {
                newPoint.date = d3.timeParse('%Y-%m-%e')(point.date);
            }

            if (this._compareData) {
                newPoint.compareData = this._compareData[index] ?
                    this._compareData[index].percent : 0;
            }

            newPoint.percent = point.percent;

            return newPoint;
        }.bind(this));
    },

    _buildTranslate: function (offset) {
        return 'translate(' + offset.x + ' ' + offset.y + ')';
    },

    /**
     * Отрисовать график
     * @param {Boolean} hasCompare
     * @private
     */
    _drawChart: function (hasCompare) {
        var self = this;

        this._chart = new this._Chart({
            name: BEM.INTERNAL.buildClass('chart', 'svg-chart'),
            width: this._canvasWidth,
            height: this._CHART_HEIGHT,
            padding: this._PADDING,
            data: this.currentData,
            tooltip: {
                top: this._tooltipTop,
                bottom: this._tooltipBottom
            },
            info: this._legend,
            hasCompare: this._compareData,
            animationDuration: this._ANIMATION_DURATION,
            barWidth: function (width) {
                return width - 1;
            }
        }, function () {
            this.x.domain(d3.extent(this.widgetData, function (d) {
                return d.date;
            }));
            this.y.domain([
                d3.min(this.widgetData, function (d) {
                    return Math.min(d.percent, self._compareData ? d.compareData : Infinity);
                }),
                d3.max(this.widgetData, function (d) {
                    return Math.max(d.percent, self._compareData ? d.compareData : -Infinity);
                })
            ]);
        });

        this._map = new this._Chart({
            name: BEM.INTERNAL.buildClass('chart', 'svg-map'),
            width: this._canvasWidth,
            padding: this._PADDING,
            data: this.currentData,
            animationDuration: this._ANIMATION_DURATION,
            height: this._MAP_HEIGHT
        }, function () {
            this.brushHeight = self._MAP_HEIGHT + 8;
            this.x.domain(self._chart.x.domain());
            this.y.domain([
                d3.min(this.widgetData, function (d) {
                    return Math.min(d.percent, Infinity);
                }),
                d3.max(this.widgetData, function (d) {
                    return Math.max(d.percent, -Infinity);
                })
            ]);
        });

        var MARGIN_CHART_MAP = 90;

        this._canvas = d3.select(this.domElem[0]).append('svg')
            .attr('width', this._canvasWidth)
            .attr('height', this._chart.height + this._map.height + MARGIN_CHART_MAP);

        this._chart.addCanvas(this._canvas);
        this._buildAxis();
        this._chart.drawChart();

        var chartLines = $('.dashboard__modal svg .axis.chart line');
        // Здесь и далее нужно, чтобы работало в ie11 (трансформы не работают в CSS)

        chartLines.attr('transform', this._buildTranslate(this._LINES_OFFSET));

        this._map.addCanvas(this._canvas);
        this._map.drawChart();
        this._buildMapsAxis();

        var chartMap = $('.chart__svg-map');

        chartMap.attr('transform', this._buildTranslate(this._MAP_OFFSET));

        this._addClipPath()._buildRange(this.currentData);

        var fromCaption = $('.chart__svg-map .text-from');

        fromCaption.attr('transform', this._buildTranslate(this._MAP_TEXT_OFFSET.from));

        var toCaption = $('.chart__svg-map .text-to');

        toCaption.attr('transform', this._buildTranslate(this._MAP_TEXT_OFFSET.to));

        d3.select(window).on('resize', $.throttle(this._onWindowResize.bind(this), 300));

        if (hasCompare) {
            this._chart.drawBars('bar-item-compare', true, false);
        }
    },

    _canvasScale: function () {
        this._chart.y.domain([
            d3.min(this.currentData, function (d) {
                return Math.min(d.percent, this._compareData ? d.compareData : Infinity);
            }.bind(this)),
            d3.max(this.currentData, function (d) {
                return Math.max(d.percent, this._compareData ? d.compareData : -Infinity);
            }.bind(this))
        ]);

        this._chart.x.domain(this.freezedDateRange);

        this._map.x.domain(d3.extent(this.currentData, function (d) {
            return d.date;
        }));

        this._map.y.domain(d3.extent(this.currentData, function (d) {
            return d.percent;
        }));
    },

    _axisTransition: function () {
        this._chart.canvas
            .select('.y.axis')
            .transition()
            .duration(this._ANIMATION_DURATION)
            .call(this._yChartAxis)
            .selectAll('text')
            .tween('attr.x', null)
            .tween('attr.dy', null);

        this._chart.canvas
            .select('.y.axis')
            .call(function (axis) {
                axis.selectAll('text')
                    .attr('x', -this._PADDING.left)
                    .attr('dy', -4);
            }.bind(this));

        this._map.canvas.select('.y.axis')
            .transition()
            .duration(this._ANIMATION_DURATION)
            .call(this._yMapAxis);
    },

    /**
     * Перестраивает график в зависимости от новых данных
     * @param {Object} opts
     */
    rebuild: function (opts) {
        this._prepareData(opts);

        if (this._empty) {
            this._canvas.remove();
            this._drawChart(opts.compareData && opts.compareData.length > 0);
            this._empty = false;

            return;
        }

        var chartXOfPreviousLastBar = this._chart.x(this.freezedDateRange[1]);
        var chartYOfPreviousLastBar = this._chart.y(0);

        var mapXOfPreviousLastBar = this._map.x(this.freezedDateRange[1]);
        var mapYOfPreviousLastBar = this._map.y(0);

        this.freezedDateRange = this._getCurrentRange(this.currentData);

        this._canvasScale();
        this._axisTransition();

        this._chart.changeData({
            data: this.currentData,
            info: this._legend,
            hasCompare: Boolean(this._compareData),
            xOfPreviousLastBar: chartXOfPreviousLastBar,
            yOfPreviousLastBar: chartYOfPreviousLastBar
        });

        this._map.changeData({
            data: this.currentData,
            xOfPreviousLastBar: mapXOfPreviousLastBar,
            yOfPreviousLastBar: mapYOfPreviousLastBar
        });

        this._brushRange = this._setRange();

        /* eslint-disable max-len */
        // FIXME: починка баги в brush с переключением фильтра с разными датами на концах, но нужно подправить анимацию
        // this._map.canvas.select('.x.brush')
        //     .transition()
        //     .duration(this._ANIMATION_DURATION)
        //     .call(this._brushRange.move, this._getRange(this.freezedDateRange));

        this._map.canvas
            .select('.text-from')
            .text(this._dateFormat(this.freezedDateRange[0]));

        this._map.canvas
            .select('.text-to')
            .text(this._dateFormat(this.freezedDateRange[1]));

        this._setSelectedBar(this._map.bars['bar-item'].enter,
            this.freezedDateRange);
        this._setSelectedBar(this._map.bars['bar-item'].update,
            this.freezedDateRange);
    },

    renderMessage: function (message) {
        if (this._empty) {
            return;
        }

        var canvasWidth = this._canvasWidth / 2;
        var chartHeight = this._CHART_HEIGHT / 2;

        this._canvas.selectAll('g').remove();
        this._canvas.selectAll('clipPath').remove();
        this._empty = true;
        this._canvas
            .append('text')
            .attr('class', 'message')
            .attr('width', this._canvasWidth)
            .attr('transform',
                'translate(' + canvasWidth + ',' + chartHeight + ')')
            .attr('text-anchor', 'middle')
            .text(message);
    },

    /**
     * Создание оси X для графика-карты
     * @returns {_buildAxis}
     * @private
     */
    _buildMapsAxis: function () {
        /* eslint-disable max-len */
        this._yMapAxis = d3.axisRight()
            .scale(this._map.y)
            .ticks(0.5)
            .tickSize(this._map.width - this._PADDING.left - this._PADDING.right)
            .tickFormat('');

        this._map.canvas.append('g')
            .attr('class', 'y axis map')
            .call(this._yMapAxis);

        return this;
    },

    destruct: function () {
        d3.select(window).on('resize', null);
    },

    /**
     * Создание оси Y
     * @returns {_buildAxis}
     * @private
     */
    _buildAxis: function () {
        this._yChartAxis = d3.axisRight()
            .scale(this._chart.y)
            .tickSize(this._canvasWidth)
            .tickFormat(function (d) {
                return Math.round(d * 100) / 100 + '%';
            });

        this._chart.canvas.append('g')
            .attr('class', 'y axis chart')
            .call(this._yChartAxis)
            .selectAll('text')
            .attr('x', -this._PADDING.left)
            .attr('dy', -4);

        var ticks = this._chart.canvas.selectAll('.axis.chart .tick line');

        ticks.each(function (data) {
            var tick = d3.select(this);

            tick.classed('bold', function () {
                return data === 0;
            });
        });

        return this;
    }
});
