BEM.decl({
    block: 'chart',
    modName: 'type',
    modVal: 'widget'
}, {
    onSetMod: {
        js: {
            inited: function () {
                this._CHART_HEIGHT = 44;
                this._ANIMATION_DURATION = 700;
                this._PADDING = { top: 0, left: 0, right: 0 };

                this.__base.apply(this, arguments);
            }
        }
    },

    _prepareData: function () {
        this._data = this.params.data.map(function (point) {
            var date = point.date;

            if (!(date instanceof Date)) {
                date = d3.timeParse('%Y-%m-%e')(point.date);
            }

            return {
                date: date,
                percent: point.percent
            };
        });
    },

    /**
     * Отрисовать график
     * @private
     */
    _drawChart: function () {
        var self = this;

        this._chart = new this._Chart({
            name: BEM.INTERNAL.buildClass('chart', 'svg-chart'),
            width: this._container.width(),
            height: this._CHART_HEIGHT,
            padding: this._PADDING,
            data: this._data,
            animationDuration: this._ANIMATION_DURATION,
            barWidth: function (width) {
                return width - 1;
            },
            type: 'area'
        }, function () {
            this.x.domain(d3.extent(self._data, function (d) {
                return d.date;
            }));

            this.y.domain([
                d3.min(this.widgetData, function (d) {
                    return Math.min(d.percent, Infinity);
                }),
                d3.max(this.widgetData, function (d) {
                    return Math.max(d.percent, -Infinity);
                })
            ]);
        });

        var canvas = d3.select(this.domElem[0]).append('svg')
            .attr('width', this._canvasWidth)
            .attr('height', this._chart.height);

        this._canvas = canvas;

        var circleRadius = 2;

        canvas.append('clipPath')
            .attr('id', 'clip')
            .append('rect')
            .attr('class', 'clip')
            .attr('width', 0)
            .attr('height', this._chart.height + (2 * circleRadius));

        this._chart.addCanvas(canvas);

        this._buildAxis();

        this._chart.drawChart();
    },

    /**
     * Создание оси Y
     * @returns {_buildAxis}
     * @private
     */
    _buildAxis: function () {
        var xAxis = d3.axisRight()
            .scale(this._chart.y)
            .tickValues([0])
            .tickSize(this._canvasWidth)
            .tickFormat('');

        this._chart.canvas.append('g')
            .attr('class', 'y axis')
            .call(xAxis);

        return this;
    }
});
