BEM.decl({
    block: 'chart2',
    modName: 'type',
    modVal: 'bars'
}, {
    onSetMod: {
        js: {
            inited: function () {
                var desktopPadding = { top: 26, left: 0, right: 0 };
                var touchPadding = { top: 26, left: 0, right: 0 };

                this.TAIL = 6;
                this.CHART_OFFSET = 10;
                this.MAP_OFFSET = 330;
                this.MAP_MARGIN = 30;
                this.PADDING = this.isMobile ? touchPadding : desktopPadding;

                this._tooltip = {
                    top: this.findBlockOutside('b-page').findBlockInside({
                        blockName: 'popup',
                        modName: 'name',
                        modVal: 'chart-bars-top'
                    }),
                    bottom: this.findBlockOutside('b-page').findBlockInside({
                        blockName: 'popup',
                        modName: 'name',
                        modVal: 'chart-bars-bottom'
                    })
                };

                this.__base.apply(this, arguments);
            }
        }
    },

    _parseQuarter: function (string) {
        var result = string.match(/Q(\d).+(\d\d)/);
        var month = parseInt(result[1], 10) * 3;
        var year = parseInt(result[2], 10);
        var date = new Date(2000 + year, month - 1, 1);

        return date;
    },

    _prepareData: function () {
        var chart = this.params.chart;

        this.data = {};

        this.data = chart.data.map(function (barData) {
            barData.values = barData.values.map(function (bar) {
                return {
                    date: this._parseQuarter(bar.date),
                    quarter: bar.date,
                    value: bar.value
                };
            }.bind(this));

            var lastDate = new Date(barData.values[barData.values.length - 1].date);

            lastDate.setMonth(lastDate.getMonth() + 3);
            barData.values.push({
                date: lastDate,
                quarter: '',
                value: 0
            });

            return barData;
        }.bind(this));

        this.dates = this.data[0].values.map(function (bar) {
            return bar.date;
        });
    },

    _draw: function () {
        var self = this;
        var yRange = this._getYRange([this.data[0]]);

        this._chart = new this._Canvas({
            name: BEM.INTERNAL.buildClass('chart2', 'svg-chart'),
            width: this._canvasWidth,
            height: 328,
            data: this.data,
            tooltip: this._tooltip,
            postfix: '%',
            dateFormat: function (date) {
                var month = date.getMonth();
                var quarter = 'Q' + parseInt(month / 3 + 1, 10);
                var year = date.getFullYear();

                return quarter + '\'' + year.toString().substr(2);
            }
        }, function () {
            this.x.domain(d3.extent(self.dates));
            this.y.domain(yRange);
        }, this);

        this._map = new this._Canvas({
            name: BEM.INTERNAL.buildClass('chart2', 'svg-map'),
            width: this._canvasWidth,
            height: 50,
            data: this.data
        }, function () {
            this.x.domain(self._chart.x.domain());
            this.y.domain(self._chart.y.domain());
        }, this);

        this._svg = d3.select(this.domElem[0]).append('svg')
            .attr('width', this._canvasWidth)
            .attr('height', this._chart.height + this._map.height + this.MAP_MARGIN);

        this._chart.drawOn(this._svg);
        this._map.drawOn(this._svg, { topOffset: this.MAP_OFFSET });

        this._addClipPath();
        this._buildAxis();

        this._drawChartBars();
        this._drawMap();
    },

    /**
     * Перерисовывает данные на графике при ресайзе страницы
     * @private
     */
    /* eslint-disable no-empty-function */
    _updateChartData: function () {},

    _buildAxis: function () {
        this._yChartAxis = d3.axisRight()
            .scale(this._chart.y)
            .ticks(1)
            .tickValues([0])
            .tickSize(this._chart.width);

        this._yMapAxis = d3.axisRight()
            .scale(this._map.y)
            .ticks(0.5)
            .tickSize(this._map.width - this.PADDING.left - this.PADDING.right);

        this._chart.canvasSvg.append('g')
            .attr('class', 'y axis chart')
            .call(this._yChartAxis);

        this._map.canvasSvg.append('g')
            .attr('class', 'y axis map')
            .call(this._yMapAxis);
    },

    /* eslint-disable complexity */
    _onBrushMove: function () {
        var selection = d3.event.selection;
        var dateRange = this._getDateRange(selection);
        var newDateRange = dateRange;

        if (d3.event.type === 'brush') {
            newDateRange = dateRange.map(d3.timeMonth.round);
            var timeMonthsLength = d3.timeMonths(newDateRange[0], newDateRange[1]).length / 3;

            if (timeMonthsLength === this.TAIL) {
                this.freezedDateRange = newDateRange;
            }

            if (timeMonthsLength < this.TAIL) {
                newDateRange[0] = d3.min([newDateRange[0], this.freezedDateRange[0]]);
                newDateRange[1] = d3.max([newDateRange[1], this.freezedDateRange[1]]);
            }
        }

        if (d3.event.sourceEvent && d3.event.sourceEvent.type !== 'brush') {
            this._moveBrush(this._getRange(newDateRange));
        }

        this._chart.x.domain(newDateRange);

        this._calculateWidthBar();
        this._chart._updateBar(this._chart.canvasSvg.select('#groupBar').selectAll('g'), {
            className: 'bar-item'
        });

        this._drawBrushLabels();
    },
    /* eslint-enable complexity */

    _drawChartBars: function () {
        this._chart.canvasSvg.append('g')
            .attr('id', 'groupBar')
            .attr('clip-path', 'url(#barsClip)');

        this._map.canvasSvg.append('g')
            .attr('id', 'groupBar');

        this._drawBars(this._chart, true);
        this._drawBars(this._map);

        this._chart.canvasSvg.selectAll('.bar-item');
    },

    _drawBars: function (canvas, showText) {
        this._calculateWidthBar();
        canvas.bars = canvas.canvasSvg
            .select('#groupBar')
            .selectAll('.bar-item')
            .data(this.data[0].values);

        var newBar = canvas.bars.enter()
            .append('g');

        newBar.append('rect');

        if (showText) {
            newBar.append('text').attr('class', 'bar-quarter');
            newBar.append('text').attr('class', 'bar-value');
        }

        canvas.bars = {
            enter: canvas._updateBar(newBar, { className: 'bar-item' })
        };
    },

    _calculateWidthBar: function () {
        /* eslint-disable max-len */
        var fullWidth = this._chart.x(this.data[0].values[1].date) - this._chart.x(this.data[0].values[0].date);

        this._widthBar = fullWidth - 6;

        return this._widthBar;
    },

    _getClassName: function (className, data) {
        className += data.value < 0 ? ' neg' : ' pos';

        return className;
    },

    _addClipPath: function () {
        var width = this._chart.width - 2 * this.CHART_OFFSET;

        this._svg.append('clipPath')
            .attr('id', 'barsClip')
            .append('rect')
            .attr('class', 'clip-animate')
            .attr('x', this.CHART_OFFSET)
            .attr('y', -this.PADDING.top)
            .attr('width', width)
            .attr('height', this._chart.height + 2 * this.PADDING.top);
    }
});
