BEM.DOM.decl('chart2', {
    onSetMod: {
        js: {
            inited: function () {
                this.isMobile = BH.lib.global.isMobile;

                this._container = this.domElem.parent();
                this._canvasWidth = this._container.width();

                this._prepareData();
                this._draw();
            }
        }
    },

    _Canvas: function (opts, callback, context) {
        this.name = opts.name;
        this.padding = opts.padding || context.PADDING;
        this.width = opts.width;
        this.height = opts.height;
        this.data = opts.data;
        this.animationDuration = 700;
        this.tooltip = opts.tooltip;
        this.scale = 0;
        this.postfix = opts.postfix || '';
        this.dateFormat = opts.dateFormat || d3.timeFormat('%m.%Y');

        var rightBorder = this.width - context.CHART_OFFSET - this.padding.left;

        this.x = d3.scaleTime().range([context.CHART_OFFSET, rightBorder]);
        this.y = d3.scaleLinear().range([this.height, 0]);

        this.accessor = function (axis, d) {
            if (axis === 'x') {
                return this.x(d.date);
            } else if (axis === 'y') {
                return this.y(d.value);
            }
        };

        callback.call(this);

        /**
         * Функция для перерисовки графика при ресайзе страницы
         * @param width
         */
        // this.resize = function (width) {
        //     this.x.range([context.CHART_OFFSET, width - 2 * context.CHART_OFFSET]);
        //     this._updateChartData();
        // };

        this._onMouseOver = function (type, data) {
            if (!this.tooltip) {
                return;
            }

            var $target = $(d3.event.target);
            var direction = null;
            var css = {};

            if (type === 'bars') {
                var height = data.value < 0 ? $target.attr('height') : 0;
                var offsetHorizontal = Math.round($target.attr('width') / 2);

                direction = data.value < 0 ? 'bottom' : 'top';
                css = { transform: 'translate(' + offsetHorizontal + 'px, ' + height + 'px)' };
            } else {
                direction = 'top';
            }

            var tooltip = this.tooltip[direction];

            tooltip.setContent(BH.apply({
                block: 'chart-tooltip',
                mods: { type: type },
                data: {
                    date: this.dateFormat(data.date),
                    value: data.value + this.postfix
                }
            }));

            tooltip.hide();
            tooltip.show($target.offset());

            tooltip.domElem.css(css);
        };

        this._onMouseOut = function () {
            if (!this.tooltip) {
                return;
            }
            Object.keys(this.tooltip)
                .forEach(function (direction) {
                    this.tooltip[direction].hide();
                }.bind(this));
        };

        this.drawOn = function (svg, options) {
            options = options || {};

            var top = this.padding.top + (options.topOffset || 0);

            this.canvasSvg = svg
                .append('g')
                .attr('transform', 'translate(' + this.padding.left + ', ' + top + ')')
                .attr('class', this.name);
        };

        this._updateBar = function (selection, options) {
            this._updateBarText(selection);

            return selection
                .select('rect')
                .attr('class', context._getClassName.bind(context, options.className))
                .attr('x', function (d) {
                    return this.x(d.date);
                }.bind(this))
                .attr('width', context._widthBar)
                .attr('y', function (d) {
                    return this.y(Math.max(0, d.value));
                }.bind(this))
                .attr('height', function (d) {
                    return Math.abs(this.y(0) - this.y(d.value));
                }.bind(this));
        };

        this._updateBarText = function (selection) {
            selection
                .selectAll('text')
                .attr('transform', function (d, i) {
                    var yOffset = d.value < 0 ? (34 - 16 * i) : (-26 + 18 * i);

                    return 'translate(0, ' + yOffset + ')';
                })
                .attr('x', function (d) {
                    return this.x(d.date) + context._widthBar / 2;
                }.bind(this))
                .attr('y', function (d) {
                    return this.y(d.value);
                }.bind(this))
                .text(function(d, i) {
                    return i ? d.value + this.postfix : d.quarter;
                }.bind(this));
        };
    },

    _getYRange: function (data) {
        var min = Infinity;
        var max = -Infinity;

        data.forEach(function (lineData) {
            var minValue = d3.min(lineData.values, function (dot) {
                return dot.value;
            });

            var maxValue = d3.max(lineData.values, function (dot) {
                return dot.value;
            });

            min = Math.min(minValue, min);
            max = Math.max(maxValue, max);
        });

        min -= 10 - Math.abs(min % 10);
        max += 10 - Math.abs(max % 10);

        return [min, max];
    },

    _getRange: function (dateRange) {
        return [
            this._map.x(dateRange[0]),
            this._map.x(dateRange[1])
        ];
    },

    _getDateRange: function (coordinates) {
        return coordinates.map(this._map.x.invert, this._map.x);
    },

    _getInitialDateRange: function (dates) {
        var length = dates.length;
        var start = length <= this.TAIL ? dates[0] : dates[length - this.TAIL - 1];
        var end = dates[length - 1];

        return [start, end];
    },

    _moveBrush: function (range) {
        range = range || this._getRange(d3.brushSelection(this._brush.node()));
        this._map.canvasSvg.select('.brush').call(this._brushRange.move, range);
    },

    _onBrushEnd: function () {
        var range = d3.event.selection;

        if (!range) {
            return;
        }
        this.freezedDateRange = this._getDateRange(range);
    },

    _drawMap: function () {
        this._map.canvasSvg.append('g')
            .attr('class', 'map');

        this._brushRange = d3.brushX()
            .extent([
                [this.CHART_OFFSET, 0],
                [this._map.width - this.CHART_OFFSET - this._map.padding.right, this._map.height]
            ])
            .on('start brush', this._onBrushMove.bind(this))
            .on('end', this._onBrushEnd.bind(this));

        var initialDateRange = this._getInitialDateRange(this.dates);
        var initialRange = this._getRange(initialDateRange);

        this.freezedDateRange = initialDateRange;

        this._brush = this._map.canvasSvg.append('g')
            .attr('class', 'brush')
            .call(this._brushRange)
            .call(this._brushRange.move, initialRange);

        this._brush.selectAll('.handle--custom')
            .data([
                { type: 'w' },
                { type: 'e' }
            ])
            .enter()
            .append('g')
            .attr('class', 'handle--custom');

        this._drawBrushLabels();

        this._brush.selectAll('rect')
            .attr('shape-rendering', 'crispEdges');
    },

    _drawBrushLabels: function () {
        this._map.canvasSvg.selectAll('.handle')
            .attr('y', 1.5)
            .attr('width', 6)
            .attr('height', 48);
    }
});
