module.exports = function (bh) {
    bh.match('chat-imitation', function (ctx, json) {
        var data = json.data;

        var replicas = (data.replicas || [])
            .filter(notEmptyReplica)
            .map(buildReplica);

        ctx
            .js({
                metrika: data.metrika || []
            })
            .content(replicas);
    });

    function notEmptyReplica(replica) {
        return (replica.text || '').length > 0;
    }

    function buildReplica(replica) {
        return {
            elem: 'replica',
            mods: { position: replica.position },
            content: replica.text
        };
    }
};
