module.exports = function (bh) {
    'use strict';
    bh.match('contact-form__attach', function (ctx, json) {
        var attach = json.attach;

        ctx.content([
            attach.label && {
                elem: 'label',
                content: {
                    elem: 'label-text',
                    mods: {
                        type: 'full',
                        required: attach.required && 'yes'
                    },
                    content: attach.label
                }
            },
            {
                block: 'file-upload',
                required: attach.required,
                tip: attach.tip,
                maxFilesSize: attach.maxFilesSize,
                maxFilesCount: attach.maxFilesCount
            }
        ]);
    });
};
