module.exports = function (bh) {
    var modalImages = [
        'https://avatars.mds.yandex.net/get-adv/28496/2a000001616f9d3352be073b01eddfa5674a/orig',
        'https://avatars.mds.yandex.net/get-adv/135342/2a000001616f9d8f2ddda0f5b61dc8f6aecc/orig'
    ];

    bh.match('contact-form__disk', function (ctx) {
        ctx.content([
            {
                elem: 'disk-row',
                content: {
                    block: 'button',
                    target: '_blank',
                    mods: {
                        size: 'm',
                        theme: 'normal'
                    },
                    url: 'https://disk.yandex.' + bh.lib.global.tld,
                    content: bh.lib.i18n('partners', 'form.disk.button')
                }
            },
            {
                elem: 'disk-row',
                content: {
                    block: 'link',
                    mods: { theme: 'pseudo', pseudo: 'yes' },
                    text: bh.lib.i18n('partners', 'form.disk.pseudolink')
                }
            },
            {
                block: 'modal',
                mods: {
                    theme: 'normal',
                    autoclosable: 'yes',
                    type: 'basic',
                    size: 'm'
                },
                content: {
                    block: 'contact-form',
                    elem: 'disk-popup'
                }
            }
        ]);
    });

    bh.match('contact-form__disk-popup', function (ctx) {
        ctx.content([
            {
                elem: 'disk-text',
                content: bh.lib.i18n('partners', 'form.disk.modal.1')
            },
            {
                elem: 'disk-image',
                mods: { first: true },
                src: modalImages[0]
            },
            {
                elem: 'disk-text',
                content: bh.lib.i18n('partners', 'form.disk.modal.2')
            },
            {
                elem: 'disk-image',
                mods: { second: true },
                src: modalImages[1]
            }
        ]);
    });

    bh.match('contact-form__disk-text', function (ctx) {
        ctx.mix({ block: 'html-content' });
    });

    bh.match('contact-form__disk-image', function (ctx, json) {
        ctx
            .tag('img')
            .attrs({
                src: json.src
            });
    });
};
