module.exports = function (bh) {
    bh.match('contact-form__select', function (ctx, json) {
        var options = ctx.param('options');
        var empty = ctx.param('empty');
        var firstOption = options[0];
        var required = ctx.param('required');

        ctx
            .content([
                {
                    block: 'select',
                    mods: { size: 'm', theme: 'normal', layout: 'content' },
                    js: {
                        required: required,
                        options: options.reduce(function (result, option) {
                            result[option.value] = option.tip || '';

                            return result;
                        }, {})
                    },
                    content: [
                        {
                            block: 'button',
                            mods: { theme: 'normal' },
                            content: empty ? bh.lib.i18n('forms', 'emptyValue') : firstOption.value
                        },
                        {
                            elem: 'control',
                            attrs: {
                                name: json.name
                            },
                            content: [
                                empty && {
                                    elem: 'option',
                                    attrs: { value: '' },
                                    content: bh.lib.i18n('forms', 'emptyValue')
                                },
                                options.map(function (option) {
                                    return {
                                        elem: 'option',
                                        attrs: { value: option.value },
                                        content: option.value
                                    };
                                })
                            ]
                        },
                        required && {
                            elem: 'message',
                            elemMods: { type: 'error' },
                            content: bh.lib.i18n('partners', 'form.error.required')
                        }
                    ]
                },
                {
                    elem: 'tip',
                    content: !empty && firstOption.tip
                }
            ]);
    });
};
