module.exports = function (bh) {
    var fullWidthFields = ['textarea', 'checkbox'];

    /* eslint-disable complexity */
    function input(field, options) {
        options = options || {};
        var userEmail = bh.lib.global.userEmail;

        return [
            {
                block: 'input',
                mods: {
                    size: 'm',
                    type: options.type,
                    side: options.theme
                },
                placeholder: options.placeholder && field.label,
                js: {
                    required: field.required,
                    email: options.email,
                    name: options.name
                },
                content: [
                    {
                        elem: 'control'
                    },
                    (options.email && userEmail) && {
                        elem: 'samples',
                        content: {
                            block: 'link',
                            mods: { theme: 'pseudo', pseudo: 'yes' },
                            mix: { block: 'input', elem: 'sample' },
                            content: userEmail
                        }
                    },
                    (options.email || field.required) && {
                        elem: 'message',
                        elemMods: { type: 'error' },
                        content: bh.lib.i18n('partners', options.email ?
                            'form.error.email' : 'form.error.required')
                    }
                ]
            },
            field.tip && {
                elem: 'tip',
                content: field.tip
            }
        ];
    }

    function buildFormField(field, isCompact, theme) {
        var controls = {
            input: function () {
                return input(field, { placeholder: isCompact, theme: theme, name: field.name });
            },
            number: function () {
                return input(field, { type: 'number', theme: theme, name: field.name });
            },
            textarea: function () {
                return input(field, { type: 'textarea', theme: theme, name: field.name });
            },
            link: function () {
                return [
                    input(field, { type: 'link', theme: theme, name: field.name }),
                    {
                        elem: 'link-tip',
                        content: [
                            { elem: 'disk' }
                        ]
                    }
                ];
            },
            email: function () {
                return input(field, {
                    email: true,
                    placeholder: isCompact,
                    theme: theme,
                    name: field.name
                });
            },
            select: function () {
                return {
                    elem: 'select',
                    required: field.required,
                    options: field.options,
                    name: field.name,
                    empty: true
                };
            },
            checkbox: function () {
                return {
                    elem: 'checkbox',
                    options: field.options,
                    tip: field.tip,
                    name: field.name,
                    theme: theme
                };
            }
        };

        var content = controls[field.type] && controls[field.type]();
        var isFullWidth = fullWidthFields.indexOf(field.type) > -1;

        if (!content) {
            return '';
        }

        return {
            elem: 'row',
            mix: {
                block: 'clearfix'
            },
            content: [
                !isCompact && {
                    elem: 'label',
                    content: {
                        elem: 'label-text',
                        mods: {
                            type: isFullWidth && 'full',
                            required: field.required && 'yes'
                        },
                        content: field.label
                    }
                },
                {
                    elem: 'control',
                    mods: { type: isFullWidth && 'full' },
                    content: content
                }
            ]
        };
    }
    /* eslint-enable complexity */

    function getFieldsList(fields, attachItems, options) {
        var fieldsList = fields.map(function (item) {
            return buildFormField(item, options.isCompact, options.theme);
        });

        if (!attachItems || !attachItems.length) {
            return fieldsList;
        }

        attachItems.forEach(function (attach) {
            var attachElem = {
                elem: 'row',
                content: {
                    elem: 'attach',
                    attach: attach
                }
            };

            if (parseInt(attach.order, 10) < fieldsList.length) {
                fieldsList.splice(attach.order, 0, attachElem);
            } else {
                fieldsList.push(attachElem);
            }
        });

        return fieldsList;
    }

    /* eslint-disable complexity */
    bh.match('contact-form', function (ctx, json) {
        var isCompact = json.mods.type === 'compact';
        var fields = json.fields.slice(0);
        var theme = json.mods.theme;

        var fieldsList = getFieldsList(fields, json.attachItems, {
            isCompact: isCompact,
            theme: theme
        });

        ctx
            .tag('form')
            .content([
                {
                    elem: 'data',
                    content: [
                        json.caption && {
                            elem: 'title',
                            content: json.caption
                        },
                        json.description && {
                            elem: 'description',
                            mix: { block: 'html-content' },
                            content: json.description
                        },
                        fieldsList,
                        {
                            block: 'secret-key-input'
                        },
                        {
                            elem: 'submit',
                            theme: theme,
                            button: json.button,
                            agreements: json.agreements,
                            hasCaptcha: json.hasCaptcha
                        }
                    ]
                },
                {
                    elem: 'message',
                    mods: { hidden: 'yes' },
                    content: [
                        {
                            elem: 'message-title',
                            content: json.successTitle || bh.lib.i18n('forms', 'success.def.title')
                        },
                        {
                            tag: 'p',
                            content: json.successText || bh.lib.i18n('forms', 'success.def.text')
                        }
                    ]
                }
            ]);
    });
    /* eslint-enable complexity */

    bh.match('contact-form__submit', function (ctx, json) {
        if (!json.button) {
            return '';
        }

        return [
            {
                elem: 'agreements',
                agreements: json.agreements,
                theme: json.theme
            },
            {
                elem: 'footer',
                elemMods: { align: json.button.align || '' },
                content: [
                    json.hasCaptcha && {
                        block: 'captcha',
                        silent: true,
                        refreshCaptchaUrl: bh.lib.global.refreshCaptchaUrl
                    },
                    { elem: 'error' },
                    { elem: 'loader' },
                    { elem: 'button', button: json.button }
                ]
            }
        ];
    });

    bh.match('contact-form__error', function (ctx) {
        ctx.content({ elem: 'error-message' });
    });

    bh.match('contact-form__loader', function (ctx) {
        ctx.content({ block: 'spin2', mods: { size: 'm' } });
    });

    bh.match('contact-form__button', function (ctx, json) {
        var mods = bh.lib.util.merge({
            theme: 'action',
            size: 'm'
        }, json.buttonMods);

        return {
            block: 'button',
            mods: mods,
            content: json.button.text
        };
    });

    function buildAgreementFromString(agreement) {
        return {
            elem: 'agreement',
            content: [
                {
                    block: 'checkbox',
                    mods: { theme: 'normal', size: 'm', required: 'yes' },
                    text: {
                        elem: 'label',
                        content: [
                            agreement, {
                                elem: 'message',
                                content: bh.lib.i18n('partners', 'form.error.required')
                            }
                        ]
                    }
                }
            ]
        };
    }

    function buildAgreementFromObject(agreement, theme) {
        var label = agreement.label;
        var description = agreement.description;

        return {
            elem: 'modal-agreement',
            content: [
                {
                    block: 'checkbox',
                    mods: {
                        theme: 'normal',
                        size: 'm',
                        required: 'yes',
                        side: theme
                    },
                    text: {
                        elem: 'label',
                        content: [
                            bh.lib.util.template(label),
                            {
                                elem: 'message',
                                content: bh.lib.i18n('partners', 'form.error.required')
                            }
                        ]
                    }
                },
                {
                    block: 'modal',
                    mods: {
                        theme: 'normal',
                        autoclosable: 'yes',
                        type: 'basic',
                        size: 's'
                    },
                    title: bh.lib.i18n('common', 'conditions'),
                    content: description
                }
            ]
        };
    }

    function buildAgreement(agreement, theme) {
        return (agreement instanceof Object) ?
            buildAgreementFromObject(agreement, theme) : buildAgreementFromString(agreement, theme);
    }

    bh.match('contact-form__title', function (ctx) {
        ctx.tag('h2');
    });

    bh.match('contact-form__agreements', function (ctx, json) {
        if (!Array.isArray(json.agreements) || !json.agreements.length) {
            return '';
        }

        ctx.content(json.agreements.map(function (agreement) {
            return buildAgreement(agreement, json.theme);
        }));
    });
};
