BEM.DOM.decl('contact-form', {
    onSetMod: {
        js: function () {
            this.blockName = 'contact-form';
            this._isProcessing = false;
            this._goalId = this.params.metrikaGoalId;
            this._findElems();
            this._bindEvents();

            if (this.params.extraAnalytics) {
                BEM.blocks['i-bem'].reachTime('STAY', 20000);

                this._scrollHandler = $.debounce(this._detectScroll.bind(this), 300);

                this.bindToWin('scroll', this._scrollHandler);
            }

            this._detectScroll();
        }
    },

    /**
     * Скролл до элемента
     */
    _detectScroll: function () {
        var winBottomOffset = BEM.DOM.win.scrollTop() + BEM.DOM.win.height();
        var isReached = winBottomOffset > this.domElem.offset().top;

        if (isReached) {
            BEM.blocks.metrika.reachGoal('SHOW_COVER');
            this.unbindFromWin('scroll', this._scrollHandler);
        }
    },

    _findElems: function () {
        this._sk = this.findBlockInside('secret-key-input').domElem.val();
        this._controls = this.findBlocksInside('select').concat(this.findBlocksInside('input'));
        this._agreements = this.findBlocksInside('agreements', 'checkbox');
        this._checkboxes = this.findBlocksInside('checkbox', 'checkbox');
        this._attachItems = this.findBlocksInside('data', 'file-upload');
        this._captcha = this.findBlockInside('captcha');

        this._fieldsWrapper = this.elem('data');

        this._sendButton = this.findBlockInside({
            block: 'button',
            modName: 'theme',
            modVal: 'action'
        });

        this._spinner = this.findBlockInside('spin2');
        this._responseError = this.findElem('error');
        this._responseErrorMessage = this.findElem('error-message');

        if (!this._captcha) {
            return;
        }

        this._showCaptcha();

        if (!this._captcha.isVisible() || !this._captcha.hasValue()) {
            this._sendButton.setMod('disabled', 'yes');
        }
    },

    _showCaptcha: function () {
        if (this._captcha) {
            this._captcha._refresh();
            this._captcha.enable();
        }
    },

    _bindEvents: function () {
        this._sendButton.on('click', this._send.bind(this));

        if (this._captcha) {
            this._captcha.on('captcha-input-change', this._checkForm.bind(this));
        }

        BEM.blocks.select.on(this._fieldsWrapper, 'change', this._onControlsChange.bind(this));
        BEM.blocks.input.on(this._fieldsWrapper, 'change', this._onControlsChange.bind(this));
        BEM.blocks.checkbox.on(this._fieldsWrapper, 'change', this._onControlsChange.bind(this));
    },

    _checkForm: function () {
        if (!this._captcha) {
            return;
        }

        var captchaHasSymbol = !this._captcha.isVisible() || this._captcha.hasValue();

        this._sendButton.toggleMod('disabled', '', 'yes', captchaHasSymbol);
    },

    _onControlsChange: function (event) {
        var block = event.block;

        if (block.domElem.hasClass('select')) {
            var $tip = block.domElem
                .siblings(BEM.blocks['i-bem'].buildSelector(this.blockName, 'tip'));

            $tip.text(block.params.options[block.val()]);
        }

        block.delMod(block.findElem('message'), 'visibility');
    },

    /* eslint-disable complexity */
    _send: function () {
        var form = {
            form: this._getFormData(),
            formId: this.params.formId,
            formName: this.params.formName,
            agencyId: this.params.agencyId,
            orderId: this.params.orderId,
            params: this.params.params,
            subscriptionType: this.params.subscriptionType
        };

        if (!form.form || this._isProcessing || !this.params.url) {
            return;
        }

        this._hideResponseError();
        this._setFormProcessing();

        var data = this._buildFormData(form);

        this._sendButton.setMod('disabled', 'yes');

        if (this._captcha) {
            this._captcha.enable();

            if (this._captcha.isVisible()) {
                this._captcha.disable();

                data.append('key', this._captcha.getKey());
                data.append('rep', this._captcha.getValue());
                data.append('hasCaptcha', '1');
            }
        }

        var requestOptions = {
            type: 'POST',
            url: this.params.url,
            headers: {
                'x-csrf-token': this._sk
            },
            cache: false,
            contentType: false,
            processData: false,
            data: data
        };

        if (data.fake) {
            requestOptions.contentType = 'multipart/form-data; boundary=' + data.boundary;
            requestOptions.data = data.toString();
        }

        $.ajax(requestOptions)
            .done(this._showSuccessMessage.bind(this))
            .fail(this._showResponseError.bind(this))
            .always(this._removeFormProcessing.bind(this));
    },
    /* eslint-enable complexity */

    _buildFormData: function (form) {
        var data = new FormData();

        for (var field in form) {
            if (typeof form[field] !== 'undefined') {
                data.append(field, JSON.stringify(form[field]));
            }
        }

        this._attachItems.forEach(function (attachItem) {
            var files = attachItem.val() || [];

            files.forEach(function (file) {
                data.append('list', file);
            });
        });

        data.append('type', 'translation');

        return data;
    },

    _getFormData: function () {
        var result = [];
        var errors = 0;

        /* eslint-disable complexity */
        this._controls.forEach(function (control) {
            if (control.findBlockOutside('captcha')) {
                return;
            }

            var key = control.domElem
                .closest(BEM.blocks['i-bem'].buildSelector(this.blockName, 'row'))
                .find(BEM.blocks['i-bem'].buildSelector(this.blockName, 'label-text'))
                .text();
            var value = $.trim(control.val());
            var requiredError = control.params.required && !value;
            var isEmail = control.params.email;
            var emailError = isEmail && !/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(value);

            if (requiredError || emailError) {
                this._showErrorOn(control);
                errors += 1;
            }

            result.push({
                label: key,
                value: control.val(),
                name: control.params.name,
                isSelect: control.domElem.hasClass('select'),
                isEmail: isEmail
            });
        }.bind(this));

        this._attachItems.forEach(function (attachItem) {
            var attachedFiles = attachItem.val();

            if (attachItem.params.required && !attachedFiles.length) {
                this._showErrorOn(attachItem);
                errors += 1;
            }
        }.bind(this));
        /* eslint-enable complexity */

        this._checkboxes.forEach(function (checkbox) {
            result.push({
                checked: checkbox.isChecked(),
                value: checkbox.val(),
                isCheckbox: true
            });
        });

        this._agreements.forEach(function (agreement) {
            if (!agreement.isChecked()) {
                this._showErrorOn(agreement);
                errors += 1;
            }
        }.bind(this));

        if (errors) {
            return;
        }

        return result;
    },

    _showErrorOn: function (block) {
        block.setMod(block.findElem('message'), 'visibility', 'visible');
    },

    _showSuccessMessage: function () {
        this.trigger('showSuccessMessage');
        this._clearForm();
        this.setMod(this.findElem('data'), 'hidden', 'yes');
        this.delMod(this.findElem('message'), 'hidden');

        if (this._goalId) {
            BEM.blocks.metrika.reachGoal(this._goalId);
        }

        if (this.params.enableMetrika) {
            BEM.blocks.metrika.reachGoal('podpicka');
        }
    },

    _disableInput: function (item) {
        item.setMod('disabled', 'yes');
    },

    _enableInput: function (item) {
        item.delMod('disabled');
    },

    _setFormProcessing: function () {
        this._spinner.setMod('progress', 'yes');
        this._sendButton.setMod('disabled', 'yes');
        this._isProcessing = true;
        this._checkboxes.forEach(this._disableInput);
        this._controls.forEach(this._disableInput);
        this._agreements.forEach(this._disableInput);
    },

    _removeFormProcessing: function () {
        this._spinner.delMod('progress');
        this._sendButton.delMod('disabled');
        this._isProcessing = false;
        this._controls.forEach(this._enableInput);
        this._checkboxes.forEach(this._enableInput);
        this._agreements.forEach(this._enableInput);
    },

    _showResponseError: function (err) {
        var errorText = this._errorHumanize(err);

        this._responseErrorMessage.html(errorText);
        this._showCaptcha();
        this.setMod(this._responseErrorMessage, 'visibility', 'visible');
    },

    _hideResponseError: function () {
        this.delMod(this._responseErrorMessage, 'visibility');
        this._responseErrorMessage.text('');
    },

    _errorHumanize: function (err) {
        var responseJSON = err.responseJSON;

        if (responseJSON) {
            var errorMessage = BH.lib.i18n('forms', responseJSON.internalCode, {
                param: responseJSON.message
            });

            return errorMessage || responseJSON.message;
        }

        return err.statusText;
    },

    _clearForm: function () {
        this._controls.forEach(function (input) {
            input.val('');
        });
    }
});
