module.exports = function (bh) {
    bh.match('course', function (ctx, json) {
        var storage = json.storage;
        var title = storage.title;
        var text = storage.text;
        var lessons = json.lessons;

        ctx
            .js(true)
            .content([
                storage.image ? ctx.content() : [
                    title && {
                        elem: 'title',
                        tag: 'h2',
                        content: title
                    },
                    text && {
                        elem: 'text',
                        mix: { block: 'html-content' },
                        content: text
                    }
                ],
                lessons.map(function (lesson, idx) {
                    return {
                        elem: 'lesson',
                        data: lesson,
                        courseLink: json.courseLink,
                        idx: idx + 1
                    };
                })
            ], true);
    });

    bh.match('course__lesson', function (ctx, json) {
        var data = json.data;
        var title = data.title;
        var text = data.text;
        var slug = data.slug;
        var url = bh.lib.util.placeholder('{s}/{s}', json.courseLink, slug);

        ctx
            .tag('a')
            .attrs({ href: url })
            .content([
                ctx.content(),
                {
                    elem: 'lesson-content',
                    content: [
                        title && {
                            elem: 'lesson-title',
                            mix: { block: 'html-content' },
                            title: title,
                            idx: json.idx
                        },
                        text && {
                            elem: 'lesson-text',
                            mix: { block: 'html-content' },
                            content: text
                        }
                    ]
                }
            ], true);
    });
};
