module.exports = function (bh) {
    bh.match('dashboard__modal', function (ctx) {
        ctx
            .content([
                {
                    elem: 'close-button'
                },
                {
                    elem: 'filter'
                },
                {
                    elem: 'chart-wrapper',
                    content: [
                        { elem: 'chart' }
                    ]
                }
            ]);
    });

    /* eslint-disable complexity */
    bh.match('dashboard__group-column', function (ctx, json) {
        var comparison = Boolean(json.comparison);
        var name = json.name;
        var listOfNames = json.listOfNames;
        var enabledItems = json.enabledItems;
        var isSelect = Boolean(listOfNames && listOfNames.length);

        var tankerName = json.tankerName || name;
        var currentName = isSelect && json.options[name];

        ctx.content(isSelect && {
            block: 'select',
            mods: {
                size: 'm',
                theme: 'normal',
                type: name,
                comparison: comparison && 'yes'
            },
            js: {
                popupParams: name === 'region' && {
                    directions: 'bottom-right'
                }
            },
            content: [
                {
                    block: 'button',
                    mods: { theme: 'normal' },
                    content: bh.lib.i18n('dashboard', tankerName + '.' + currentName)
                },
                {
                    elem: 'control',
                    content: listOfNames.map(function (item, index) {
                        return {
                            elem: 'option',
                            attrs: {
                                value: item,
                                selected: currentName === item && 'selected',
                                disabled: !enabledItems[index] && 'disabled'
                            },
                            content: bh.lib.i18n('dashboard', tankerName + '.' + item) || item
                        };
                    })
                }
            ]
        });
    });
    /* eslint-enable complexity */

    bh.match('dashboard__group-column_name_category', function (ctx, json) {
        ctx
            .param('name', 'category')
            .param('tankerName', 'cat')
            .param('listOfNames', json.categories)
            .param('enabledItems', json.currentTree.categories)
            .applyBase();
    });

    bh.match('dashboard__group-column_name_type', function (ctx, json) {
        var listOfNames = [
            'network',
            'search'
        ];

        ctx
            .param('name', 'type')
            .param('listOfNames', listOfNames)
            .param('enabledItems', json.currentTree.types)
            .applyBase();
    });

    bh.match('dashboard__group-column_name_region', function (ctx, json) {
        ctx
            .param('name', 'region')
            .param('listOfNames', json.regions)
            .param('enabledItems', json.currentTree.regions)
            .applyBase();
    });

    bh.match('dashboard__group-column_name_platform', function (ctx, json) {
        var listOfNames = ['desktop', 'mobile'];

        ctx
            .param('name', 'platform')
            .param('listOfNames', listOfNames)
            .param('enabledItems', json.currentTree.platforms)
            .applyBase();
    });
};
