module.exports = function (bh) {
    bh.match('dashboard__widget', function (ctx, json) {
        var help = json.help;
        var showError = json.showError;

        ctx.content([
            {
                elem: 'slider-wrapper',
                content: showError ? { elem: 'widget-error' } : {
                    block: 'spin2',
                    mods: {
                        size: 'm',
                        progress: 'yes'
                    }
                }
            },
            {
                elem: 'widget-help',
                content: [
                    {
                        elem: 'help-button'
                    },
                    {
                        block: 'modal',
                        mods: { theme: 'normal', autoclosable: 'yes' },
                        content: {
                            block: 'dashboard',
                            elem: 'modal-help',
                            content: [
                                {
                                    elem: 'modal-title',
                                    content: help.title
                                },
                                {
                                    elem: 'modal-text',
                                    content: help.text
                                },
                                {
                                    elem: 'modal-close'
                                }
                            ]
                        }
                    }
                ]
            }
        ]);
    });

    bh.match('dashboard__widget-error', function (ctx) {
        ctx.content(bh.lib.i18n('dashboard', 'error.widget'));
    });

    bh.match('dashboard__widget-slider', function (ctx, json) {
        var dashboard = json.dashboard;

        ctx.content([
            {
                block: 'owl-carousel',
                js: bh.lib.global.isMobile ? {
                    options: {
                        responsive: {
                            0: {
                                items: 1
                            },
                            520: {
                                items: 2
                            },
                            780: {
                                items: 3
                            },
                            1040: {
                                items: 4
                            }
                        },
                        autoWidth: true,
                        rewind: false,
                        nav: false
                    }
                } : true,
                content: dashboard.categories.map(function (category) {
                    var currentData = dashboard.values[category.toString()];

                    if (!currentData.length) {
                        return;
                    }
                    var lastData = currentData[currentData.length - 1];
                    var lastPercent = Math.round(lastData.percent);

                    return {
                        block: 'dashboard',
                        elem: 'widget-item',
                        attrs: {
                            category: category
                        },
                        content: [
                            {
                                elem: 'widget-type',
                                content: bh.lib.i18n('dashboard', 'type.network')

                            },
                            {
                                elem: 'widget-text',
                                content: bh.lib.i18n('dashboard', 'cat.' + category)
                            },
                            {
                                elem: 'widget-data',
                                content: [
                                    {
                                        content: [
                                            {
                                                elem: 'widget-chart',
                                                content: {
                                                    block: 'chart',
                                                    mods: { type: 'widget' },
                                                    js: {
                                                        type: 'interest',
                                                        data: currentData
                                                    }
                                                }
                                            }
                                        ]
                                    },
                                    {
                                        elem: 'widget-percent',
                                        content: (lastPercent <= 0 ? '' : '+') + lastPercent + '%'
                                    }
                                ]
                            }
                        ]
                    };
                })
            }
        ]);
    });
};
